/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.logging;

import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.LogManager;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.RootLogger;
import org.apache.log4j.spi.ThrowableInformation;
import org.ssssssss.magicapi.logging.LogInfo;
import org.ssssssss.magicapi.logging.MagicLoggerContext;

public class Log4jLoggerContext
implements MagicLoggerContext {
    @Override
    public void generateAppender() {
        RootLogger logger = (RootLogger)LogManager.getRootLogger();
        PatternLayout patternLayout = new PatternLayout("%d %p [%c] - %m%n");
        MagicLog4jAppender magicLog4jAppender = new MagicLog4jAppender();
        magicLog4jAppender.setLayout((Layout)patternLayout);
        logger.addAppender((Appender)magicLog4jAppender);
    }

    static class MagicLog4jAppender
    extends AppenderSkeleton {
        MagicLog4jAppender() {
        }

        protected void append(LoggingEvent event) {
            LogInfo logInfo = new LogInfo();
            logInfo.setLevel(event.getLevel().toString().toLowerCase());
            logInfo.setMessage(String.valueOf(event.getMessage()));
            ThrowableInformation throwableInformation = event.getThrowableInformation();
            if (throwableInformation != null) {
                logInfo.setThrowable(throwableInformation.getThrowable());
            }
            MagicLoggerContext.println(logInfo);
        }

        public void close() {
        }

        public boolean requiresLayout() {
            return false;
        }
    }
}

