/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.controller;

import java.util.List;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.ssssssss.magicapi.config.MagicConfiguration;
import org.ssssssss.magicapi.config.Valid;
import org.ssssssss.magicapi.controller.MagicController;
import org.ssssssss.magicapi.controller.MagicExceptionHandler;
import org.ssssssss.magicapi.interceptor.Authorization;
import org.ssssssss.magicapi.model.Group;
import org.ssssssss.magicapi.model.JsonBean;
import org.ssssssss.magicapi.provider.MagicAPIService;

public class MagicGroupController
extends MagicController
implements MagicExceptionHandler {
    private final MagicAPIService magicAPIService;

    public MagicGroupController(MagicConfiguration configuration) {
        super(configuration);
        this.magicAPIService = configuration.getMagicAPIService();
    }

    @RequestMapping(value={"/group/delete"})
    @ResponseBody
    @Valid(readonly=false, authorization=Authorization.DELETE)
    public JsonBean<Boolean> deleteGroup(String groupId) {
        return new JsonBean<Boolean>(this.magicAPIService.deleteGroup(groupId));
    }

    @RequestMapping(value={"/group/update"})
    @ResponseBody
    @Valid(readonly=false, authorization=Authorization.SAVE)
    public synchronized JsonBean<Boolean> groupUpdate(@RequestBody Group group) {
        if (this.magicAPIService.updateGroup(group)) {
            return new JsonBean<Boolean>(true);
        }
        return new JsonBean<Boolean>(GROUP_CONFLICT);
    }

    @RequestMapping(value={"/group/list"})
    @ResponseBody
    @Valid(authorization=Authorization.VIEW)
    public JsonBean<List<Group>> groupList(String type) {
        return new JsonBean<List<Group>>(this.magicAPIService.groupList(type));
    }

    @RequestMapping(value={"/group/create"})
    @ResponseBody
    @Valid(readonly=false, authorization=Authorization.SAVE)
    public JsonBean<String> createGroup(@RequestBody Group group) {
        return new JsonBean<String>(this.magicAPIService.createGroup(group));
    }
}

