/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.controller;

import java.util.List;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.ssssssss.magicapi.config.MagicConfiguration;
import org.ssssssss.magicapi.config.Valid;
import org.ssssssss.magicapi.controller.MagicController;
import org.ssssssss.magicapi.controller.MagicExceptionHandler;
import org.ssssssss.magicapi.interceptor.Authorization;
import org.ssssssss.magicapi.model.FunctionInfo;
import org.ssssssss.magicapi.model.JsonBean;
import org.ssssssss.magicapi.provider.FunctionServiceProvider;
import org.ssssssss.magicapi.provider.MagicAPIService;

public class MagicFunctionController
extends MagicController
implements MagicExceptionHandler {
    private final FunctionServiceProvider functionService;
    private final MagicAPIService magicAPIService;

    public MagicFunctionController(MagicConfiguration configuration) {
        super(configuration);
        this.functionService = configuration.getFunctionServiceProvider();
        this.magicAPIService = configuration.getMagicAPIService();
    }

    @RequestMapping(value={"/function/list"})
    @ResponseBody
    @Valid(authorization=Authorization.VIEW)
    public JsonBean<List<FunctionInfo>> list() {
        return new JsonBean<List<FunctionInfo>>(this.magicAPIService.functionList());
    }

    @RequestMapping(value={"/function/get"})
    @ResponseBody
    @Valid(authorization=Authorization.VIEW)
    public JsonBean<FunctionInfo> get(String id) {
        return new JsonBean<FunctionInfo>(this.magicAPIService.getFunctionInfo(id));
    }

    @RequestMapping(value={"/function/backup/get"})
    @ResponseBody
    @Valid(authorization=Authorization.VIEW)
    public JsonBean<FunctionInfo> backups(String id, Long timestamp) {
        return new JsonBean<FunctionInfo>((FunctionInfo)this.functionService.backupInfo(id, timestamp));
    }

    @RequestMapping(value={"/function/backups"})
    @ResponseBody
    @Valid(authorization=Authorization.VIEW)
    public JsonBean<List<Long>> backups(String id) {
        return new JsonBean<List<Long>>(this.functionService.backupList(id));
    }

    @RequestMapping(value={"/function/move"})
    @ResponseBody
    @Valid(readonly=false, authorization=Authorization.SAVE)
    public JsonBean<Boolean> move(String id, String groupId) {
        return new JsonBean<Boolean>(this.magicAPIService.moveFunction(id, groupId));
    }

    @RequestMapping(value={"/function/save"})
    @ResponseBody
    @Valid(readonly=false, authorization=Authorization.SAVE)
    public JsonBean<String> save(@RequestBody FunctionInfo functionInfo) {
        return new JsonBean<String>(this.magicAPIService.saveFunction(functionInfo));
    }

    @RequestMapping(value={"/function/delete"})
    @ResponseBody
    @Valid(readonly=false, authorization=Authorization.DELETE)
    public JsonBean<Boolean> delete(String id) {
        return new JsonBean<Boolean>(this.magicAPIService.deleteFunction(id));
    }
}

