/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.controller;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.sql.Connection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertyNameAliases;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.MapConfigurationPropertySource;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.ssssssss.magicapi.adapter.Resource;
import org.ssssssss.magicapi.config.MagicConfiguration;
import org.ssssssss.magicapi.config.MagicDynamicDataSource;
import org.ssssssss.magicapi.config.Valid;
import org.ssssssss.magicapi.controller.MagicController;
import org.ssssssss.magicapi.controller.MagicExceptionHandler;
import org.ssssssss.magicapi.exception.InvalidArgumentException;
import org.ssssssss.magicapi.interceptor.Authorization;
import org.ssssssss.magicapi.model.JsonBean;
import org.ssssssss.magicapi.utils.IoUtils;
import org.ssssssss.magicapi.utils.JsonUtils;
import org.ssssssss.script.functions.ObjectConvertExtension;

public class MagicDataSourceController
extends MagicController
implements MagicExceptionHandler {
    private static final ClassLoader classLoader = MagicDataSourceController.class.getClassLoader();
    private static final String[] DATA_SOURCE_TYPE_NAMES = new String[]{"com.zaxxer.hikari.HikariDataSource", "org.apache.tomcat.jdbc.pool.DataSource", "org.apache.commons.dbcp2.BasicDataSource"};
    private final Resource resource;

    public MagicDataSourceController(MagicConfiguration configuration) {
        super(configuration);
        this.resource = configuration.getWorkspace().getDirectory("datasource");
        if (!this.resource.exists()) {
            this.resource.mkdir();
        }
    }

    @RequestMapping(value={"/datasource/list"})
    @ResponseBody
    @Valid(authorization=Authorization.VIEW)
    public JsonBean<List<Map<String, Object>>> list() {
        List list = this.configuration.getMagicDynamicDataSource().datasourceNodes().stream().map(it -> {
            HashMap<String, String> row = new HashMap<String, String>();
            row.put("id", it.getId());
            row.put("key", it.getKey());
            row.put("name", it.getName());
            return row;
        }).collect(Collectors.toList());
        return new JsonBean<List<Map<String, Object>>>(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/datasource/test"})
    @ResponseBody
    public JsonBean<String> test(@RequestBody Map<String, String> properties) {
        DataSource dataSource = null;
        try {
            dataSource = this.createDataSource(properties);
            Connection connection = dataSource.getConnection();
            DataSourceUtils.doCloseConnection((Connection)connection, (DataSource)dataSource);
        }
        catch (Exception e) {
            JsonBean<String> jsonBean = new JsonBean<String>(e.getMessage());
            return jsonBean;
        }
        finally {
            IoUtils.closeDataSource(dataSource);
        }
        return new JsonBean<String>();
    }

    @RequestMapping(value={"/datasource/save"})
    @Valid(readonly=false, authorization=Authorization.DATASOURCE_SAVE)
    @ResponseBody
    public JsonBean<String> save(@RequestBody Map<String, String> properties) {
        String key = properties.get("key");
        this.notBlank(key, DATASOURCE_KEY_REQUIRED);
        this.isTrue(IoUtils.validateFileName(key), DATASOURCE_KEY_INVALID);
        String name = properties.getOrDefault("name", key);
        String id = properties.get("id");
        Stream<Object> keyStream = StringUtils.isBlank((CharSequence)id) ? this.configuration.getMagicDynamicDataSource().datasources().stream() : this.configuration.getMagicDynamicDataSource().datasourceNodes().stream().filter(it -> !id.equals(it.getId())).map(MagicDynamicDataSource.DataSourceNode::getKey);
        String dsId = StringUtils.isBlank((CharSequence)id) ? UUID.randomUUID().toString().replace("-", "") : id;
        this.isTrue(keyStream.noneMatch(key::equals), DATASOURCE_KEY_EXISTS);
        int maxRows = ObjectConvertExtension.asInt((Object)properties.get("maxRows"), (int)-1);
        properties.remove("id");
        this.configuration.getMagicDynamicDataSource().put(dsId, key, name, this.createDataSource(properties), maxRows);
        properties.put("id", dsId);
        this.resource.getResource(dsId + ".json").write(JsonUtils.toJsonString(properties));
        return new JsonBean<String>(dsId);
    }

    @RequestMapping(value={"/datasource/delete"})
    @Valid(readonly=false, authorization=Authorization.DATASOURCE_DELETE)
    @ResponseBody
    public JsonBean<Boolean> delete(String id) {
        Optional<MagicDynamicDataSource.DataSourceNode> dataSourceNode = this.configuration.getMagicDynamicDataSource().datasourceNodes().stream().filter(it -> id.equals(it.getId())).findFirst();
        this.isTrue(dataSourceNode.isPresent(), DATASOURCE_NOT_FOUND);
        Resource resource = this.resource.getResource(id + ".json");
        this.isTrue(resource.delete(), DATASOURCE_NOT_FOUND);
        dataSourceNode.ifPresent(it -> this.configuration.getMagicDynamicDataSource().delete(it.getKey()));
        return new JsonBean<Boolean>(true);
    }

    @RequestMapping(value={"/datasource/detail"})
    @Valid(authorization=Authorization.DATASOURCE_VIEW)
    @ResponseBody
    public JsonBean<Object> detail(String id) {
        Resource resource = this.resource.getResource(id + ".json");
        byte[] bytes = resource.read();
        this.isTrue(bytes != null && bytes.length > 0, DATASOURCE_NOT_FOUND);
        return new JsonBean<Object>(JsonUtils.readValue(bytes, LinkedHashMap.class));
    }

    public void registerDataSource() {
        this.resource.readAll();
        List<Resource> resources = this.resource.files(".json");
        this.configuration.getMagicDynamicDataSource().datasourceNodes().stream().filter(it -> it.getId() != null).map(MagicDynamicDataSource.DataSourceNode::getKey).collect(Collectors.toList()).forEach(it -> this.configuration.getMagicDynamicDataSource().delete((String)it));
        TypeFactory factory = TypeFactory.defaultInstance();
        for (Resource item : resources) {
            Map properties = (Map)JsonUtils.readValue(item.read(), (JavaType)factory.constructMapType(HashMap.class, String.class, String.class));
            if (properties == null) continue;
            String key = (String)properties.get("key");
            String name = properties.getOrDefault("name", key);
            String dsId = (String)properties.remove("id");
            int maxRows = ObjectConvertExtension.asInt(properties.get("maxRows"), (int)-1);
            this.configuration.getMagicDynamicDataSource().put(dsId, key, name, this.createDataSource(properties), maxRows);
        }
    }

    private DataSource createDataSource(Map<String, String> properties) {
        Class<? extends DataSource> dataSourceType = this.getDataSourceType(properties.get("type"));
        if (!properties.containsKey("driverClassName") && properties.containsKey("url")) {
            String url = properties.get("url");
            String driverClass = DatabaseDriver.fromJdbcUrl((String)url).getDriverClassName();
            properties.put("driverClassName", driverClass);
        }
        DataSource dataSource = (DataSource)BeanUtils.instantiateClass(dataSourceType);
        MapConfigurationPropertySource source = new MapConfigurationPropertySource(properties);
        ConfigurationPropertyNameAliases aliases = new ConfigurationPropertyNameAliases();
        aliases.addAliases("url", new String[]{"jdbc-url"});
        aliases.addAliases("username", new String[]{"user"});
        Binder binder = new Binder(new ConfigurationPropertySource[]{source.withAliases(aliases)});
        binder.bind(ConfigurationPropertyName.EMPTY, Bindable.ofInstance((Object)dataSource));
        return dataSource;
    }

    private Class<? extends DataSource> getDataSourceType(String datasourceType) {
        if (StringUtils.isNotBlank((CharSequence)datasourceType)) {
            try {
                return ClassUtils.forName((String)datasourceType, (ClassLoader)classLoader);
            }
            catch (Exception e) {
                throw new InvalidArgumentException(DATASOURCE_TYPE_NOT_FOUND.format(datasourceType));
            }
        }
        for (String name : DATA_SOURCE_TYPE_NAMES) {
            try {
                return ClassUtils.forName((String)name, (ClassLoader)classLoader);
            }
            catch (Exception exception) {
            }
        }
        throw new InvalidArgumentException(DATASOURCE_TYPE_NOT_SET);
    }
}

