/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.controller;

import java.util.List;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.ssssssss.magicapi.config.MagicConfiguration;
import org.ssssssss.magicapi.config.Valid;
import org.ssssssss.magicapi.controller.MagicController;
import org.ssssssss.magicapi.controller.MagicExceptionHandler;
import org.ssssssss.magicapi.interceptor.Authorization;
import org.ssssssss.magicapi.model.ApiInfo;
import org.ssssssss.magicapi.model.JsonBean;
import org.ssssssss.magicapi.provider.ApiServiceProvider;
import org.ssssssss.magicapi.provider.MagicAPIService;

public class MagicAPIController
extends MagicController
implements MagicExceptionHandler {
    private final ApiServiceProvider apiServiceProvider;
    private final MagicAPIService magicAPIService;

    public MagicAPIController(MagicConfiguration configuration) {
        super(configuration);
        this.apiServiceProvider = configuration.getApiServiceProvider();
        this.magicAPIService = configuration.getMagicAPIService();
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    @Valid(readonly=false, authorization=Authorization.DELETE)
    public JsonBean<Boolean> delete(String id) {
        return new JsonBean<Boolean>(this.magicAPIService.deleteApi(id));
    }

    @RequestMapping(value={"/list"})
    @ResponseBody
    @Valid(authorization=Authorization.VIEW)
    public JsonBean<List<ApiInfo>> list() {
        return new JsonBean<List<ApiInfo>>(this.magicAPIService.apiList());
    }

    @RequestMapping(value={"/get"})
    @ResponseBody
    @Valid(authorization=Authorization.VIEW)
    public JsonBean<ApiInfo> get(String id) {
        return new JsonBean<ApiInfo>(this.magicAPIService.getApiInfo(id));
    }

    @RequestMapping(value={"/backups"})
    @ResponseBody
    @Valid(authorization=Authorization.VIEW)
    public JsonBean<List<Long>> backups(String id) {
        return new JsonBean<List<Long>>(this.apiServiceProvider.backupList(id));
    }

    @RequestMapping(value={"/backup/get"})
    @ResponseBody
    @Valid(authorization=Authorization.VIEW)
    public JsonBean<ApiInfo> backups(String id, Long timestamp) {
        return new JsonBean<ApiInfo>((ApiInfo)this.apiServiceProvider.backupInfo(id, timestamp));
    }

    @RequestMapping(value={"/api/move"})
    @ResponseBody
    @Valid(readonly=false, authorization=Authorization.SAVE)
    public JsonBean<Boolean> apiMove(String id, String groupId) {
        return new JsonBean<Boolean>(this.magicAPIService.moveApi(id, groupId));
    }

    @RequestMapping(value={"/save"})
    @ResponseBody
    @Valid(readonly=false, authorization=Authorization.SAVE)
    public JsonBean<String> save(@RequestBody ApiInfo info) {
        return new JsonBean<String>(this.magicAPIService.saveApi(info));
    }
}

