/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.config;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.RequestMappingInfoHandlerMapping;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.ssssssss.magicapi.controller.RequestHandler;
import org.ssssssss.magicapi.model.ApiInfo;
import org.ssssssss.magicapi.model.Group;
import org.ssssssss.magicapi.model.MagicEntity;
import org.ssssssss.magicapi.model.TreeNode;
import org.ssssssss.magicapi.provider.ApiServiceProvider;
import org.ssssssss.magicapi.provider.GroupServiceProvider;
import org.ssssssss.magicapi.utils.Mapping;
import org.ssssssss.magicapi.utils.PathUtils;

public class MappingHandlerMapping {
    private static final Map<String, MappingNode> mappings = new ConcurrentHashMap<String, MappingNode>();
    private static final Logger logger = LoggerFactory.getLogger(MappingHandlerMapping.class);
    private static TreeNode<Group> groups;
    private final Method method = RequestHandler.class.getDeclaredMethod("invoke", HttpServletRequest.class, HttpServletResponse.class, Map.class, Map.class);
    private final String prefix;
    private final boolean allowOverride;
    private final List<ApiInfo> apiInfos = Collections.synchronizedList(new ArrayList());
    private Mapping mappingHelper;
    private Object handler;
    private ApiServiceProvider magicApiService;
    private GroupServiceProvider groupServiceProvider;

    public MappingHandlerMapping(String prefix, boolean allowOverride) throws NoSuchMethodException {
        this.prefix = prefix;
        this.allowOverride = allowOverride;
    }

    public static ApiInfo getMappingApiInfo(HttpServletRequest request) {
        ServletWebRequest webRequest = new ServletWebRequest(request);
        String requestMapping = (String)webRequest.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE, 0);
        return MappingHandlerMapping.getMappingApiInfo(MappingHandlerMapping.buildMappingKey(request.getMethod(), requestMapping));
    }

    private static ApiInfo getMappingApiInfo(String key) {
        return mappings.get(key).getInfo();
    }

    private static String buildMappingKey(String requestMethod, String requestMapping) {
        if (!StringUtils.isEmpty((Object)requestMapping) && !requestMapping.startsWith("/")) {
            requestMapping = "/" + requestMapping;
        }
        return Objects.toString(requestMethod, "GET").toUpperCase() + ":" + requestMapping;
    }

    public static Group findGroup(String groupId) {
        TreeNode<Group> node = groups.findTreeNode(it -> it.getId().equals(groupId));
        return node != null ? node.getNode() : null;
    }

    public static List<Group> findGroups(String groupId) {
        Group group;
        ArrayList<Group> groups = new ArrayList<Group>();
        while (!"0".equals(groupId) && (group = MappingHandlerMapping.findGroup(groupId)) != null) {
            groups.add(group);
            groupId = group.getParentId();
        }
        return groups;
    }

    public void setRequestMappingHandlerMapping(RequestMappingHandlerMapping requestMappingHandlerMapping) {
        this.mappingHelper = Mapping.create((RequestMappingInfoHandlerMapping)requestMappingHandlerMapping);
    }

    public void setHandler(Object handler) {
        this.handler = handler;
    }

    public void setMagicApiService(ApiServiceProvider magicApiService) {
        this.magicApiService = magicApiService;
    }

    public void setGroupServiceProvider(GroupServiceProvider groupServiceProvider) {
        this.groupServiceProvider = groupServiceProvider;
    }

    public List<ApiInfo> getApiInfos() {
        return this.apiInfos;
    }

    public synchronized void loadGroup() {
        groups = this.groupServiceProvider.apiGroupTree();
    }

    public void registerAllMapping() {
        try {
            this.loadGroup();
            List list = this.magicApiService.listWithScript();
            if (list != null) {
                list = list.stream().filter(it -> this.groupServiceProvider.getFullPath(it.getGroupId()) != null).collect(Collectors.toList());
                for (ApiInfo info : list) {
                    try {
                        this.registerMapping(info, true);
                    }
                    catch (Exception e) {
                        logger.error("\u63a5\u53e3:{}\u6ce8\u518c\u5931\u8d25", (Object)info.getName(), (Object)e);
                    }
                }
                List resistedList = list.stream().map(MagicEntity::getId).collect(Collectors.toList());
                Iterator<ApiInfo> iterator = this.apiInfos.iterator();
                while (iterator.hasNext()) {
                    String oldId = iterator.next().getId();
                    if (resistedList.contains(oldId)) continue;
                    this.unregisterMapping(oldId, false);
                    iterator.remove();
                }
            }
        }
        catch (Exception e) {
            logger.info("\u6ce8\u518c\u63a5\u53e3\u6620\u5c04\u5931\u8d25", (Throwable)e);
        }
    }

    public ApiInfo getApiInfo(String method, String requestMapping) {
        MappingNode mappingNode = mappings.get(MappingHandlerMapping.buildMappingKey(method, this.concatPath("", requestMapping)));
        return mappingNode == null ? null : mappingNode.getInfo();
    }

    private boolean hasConflict(TreeNode<Group> group, String newPath) {
        List infos = this.apiInfos.stream().filter(info -> Objects.equals(info.getGroupId(), ((Group)group.getNode()).getId())).collect(Collectors.toList());
        for (ApiInfo apiInfo : infos) {
            Map<RequestMappingInfo, HandlerMethod> handlerMethods;
            String path = this.concatPath(newPath, "/" + apiInfo.getPath());
            String mappingKey = MappingHandlerMapping.buildMappingKey(apiInfo.getMethod(), path);
            MappingNode mappingNode = mappings.get(mappingKey);
            if (mappingNode != null) {
                if (mappingNode.getInfo().equals(apiInfo)) continue;
                return true;
            }
            if (this.allowOverride || (handlerMethods = this.mappingHelper.getHandlerMethods()).get(this.getRequestMapping(apiInfo.getMethod(), path)) == null) continue;
            return true;
        }
        for (TreeNode treeNode : group.getChildren()) {
            if (!this.hasConflict(treeNode, newPath + "/" + Objects.toString(((Group)treeNode.getNode()).getPath(), ""))) continue;
            return true;
        }
        return false;
    }

    public boolean checkGroup(Group group) {
        TreeNode<Group> oldTree = groups.findTreeNode(item -> item.getId().equals(group.getId()));
        boolean parentIdEquals = Objects.equals(oldTree.getNode().getParentId(), group.getParentId());
        boolean nameEquals = Objects.equals(oldTree.getNode().getName(), group.getName());
        if (parentIdEquals && Objects.equals(oldTree.getNode().getPath(), group.getPath())) {
            return nameEquals || !this.groupServiceProvider.exists(group);
        }
        if (!(parentIdEquals && nameEquals || !this.groupServiceProvider.exists(group))) {
            return false;
        }
        String newPath = this.groupServiceProvider.getFullPath(group.getParentId());
        return !this.hasConflict(oldTree, newPath + "/" + Objects.toString(group.getPath(), ""));
    }

    public boolean hasRegister(Set<String> paths) {
        return paths.stream().anyMatch(mappings::containsKey);
    }

    public void deleteGroup(List<String> groupIds) {
        List deleteInfos = this.apiInfos.stream().filter(info -> groupIds.contains(info.getGroupId())).collect(Collectors.toList());
        for (ApiInfo info2 : deleteInfos) {
            this.unregisterMapping(info2.getId(), true);
        }
        this.apiInfos.removeAll(deleteInfos);
    }

    public void updateGroup(Group group) {
        this.loadGroup();
        TreeNode<Group> groupTreeNode = groups.findTreeNode(item -> item.getId().equals(group.getId()));
        this.recurseUpdateGroup(groupTreeNode, true);
    }

    private void recurseUpdateGroup(TreeNode<Group> node, boolean updateGroupId) {
        this.apiInfos.stream().filter(info -> Objects.equals(info.getGroupId(), ((Group)node.getNode()).getId())).forEach(info -> {
            this.unregisterMapping(info.getId(), false);
            if (updateGroupId) {
                info.setGroupId(((Group)node.getNode()).getId());
            }
            this.registerMapping((ApiInfo)info, false);
        });
        for (TreeNode<Group> child : node.getChildren()) {
            this.recurseUpdateGroup(child, false);
        }
    }

    public boolean hasRegisterMapping(ApiInfo info) {
        String mappingKey;
        if (info.getId() != null) {
            ApiInfo oldInfo;
            MappingNode mappingNode = mappings.get(info.getId());
            ApiInfo apiInfo = oldInfo = mappingNode == null ? null : mappingNode.getInfo();
            if (oldInfo != null && Objects.equals(oldInfo.getGroupId(), info.getGroupId()) && Objects.equals(oldInfo.getMethod(), info.getMethod()) && Objects.equals(oldInfo.getPath(), info.getPath())) {
                return false;
            }
        }
        if (mappings.containsKey(mappingKey = this.getMappingKey(info))) {
            return !mappings.get(mappingKey).getInfo().getId().equals(info.getId());
        }
        if (!this.allowOverride) {
            Map<RequestMappingInfo, HandlerMethod> handlerMethods = this.mappingHelper.getHandlerMethods();
            return handlerMethods.get(this.getRequestMapping(info)) != null;
        }
        return false;
    }

    public boolean move(String id, String groupId) {
        MappingNode mappingNode = mappings.get(id);
        if (mappingNode == null) {
            return false;
        }
        ApiInfo copy = mappingNode.getInfo().copy();
        copy.setGroupId(groupId);
        if (this.hasRegisterMapping(copy)) {
            return false;
        }
        this.unregisterMapping(id, true);
        this.registerMapping(copy, true);
        return true;
    }

    public void registerMapping(ApiInfo info, boolean delete) {
        MappingNode mappingNode = mappings.get(info.getId());
        String newMappingKey = this.getMappingKey(info);
        if (mappingNode != null) {
            ApiInfo oldInfo = mappingNode.getInfo();
            String oldMappingKey = mappingNode.getMappingKey();
            if (Objects.equals(oldMappingKey, newMappingKey)) {
                if (!info.equals(oldInfo)) {
                    mappingNode.setInfo(info);
                    mappings.get(newMappingKey).setInfo(info);
                    if (delete) {
                        this.refreshCache(info);
                    }
                    logger.info("\u5237\u65b0\u63a5\u53e3:{},{}", (Object)info.getName(), (Object)newMappingKey);
                }
                return;
            }
            logger.info("\u53d6\u6d88\u6ce8\u518c\u63a5\u53e3:{},{}", (Object)oldInfo.getName(), (Object)oldMappingKey);
            mappings.remove(oldMappingKey);
            this.mappingHelper.unregister(this.getRequestMapping(oldInfo));
        }
        mappingNode = new MappingNode(info);
        mappingNode.setMappingKey(newMappingKey);
        RequestMappingInfo requestMapping = this.getRequestMapping(info);
        mappingNode.setRequestMappingInfo(requestMapping);
        mappingNode.setInfo(info);
        if (!this.overrideApplicationMapping(requestMapping)) {
            logger.error("\u63a5\u53e3{},{}\u4e0e\u5e94\u7528\u51b2\u7a81\uff0c\u65e0\u6cd5\u6ce8\u518c", (Object)info.getName(), (Object)newMappingKey);
            return;
        }
        logger.info("\u6ce8\u518c\u63a5\u53e3:{},{}", (Object)info.getName(), (Object)newMappingKey);
        mappings.put(info.getId(), mappingNode);
        mappings.put(newMappingKey, mappingNode);
        this.registerMapping(requestMapping, this.handler, this.method);
        if (delete) {
            this.refreshCache(info);
        }
    }

    private void refreshCache(ApiInfo info) {
        this.apiInfos.removeIf(i -> i.getId().equalsIgnoreCase(info.getId()));
        this.apiInfos.add(info);
    }

    private void registerMapping(RequestMappingInfo requestMapping, Object handler, Method method) {
        this.mappingHelper.register(requestMapping, handler, method);
    }

    public void unregisterMapping(String id, boolean delete) {
        MappingNode mappingNode = mappings.remove(id);
        if (mappingNode != null) {
            ApiInfo info = mappingNode.getInfo();
            logger.info("\u53d6\u6d88\u6ce8\u518c\u63a5\u53e3:{}", (Object)info.getName());
            mappings.remove(mappingNode.getMappingKey());
            this.mappingHelper.unregister(mappingNode.getRequestMappingInfo());
            if (delete) {
                this.apiInfos.removeIf(i -> i.getId().equalsIgnoreCase(info.getId()));
            }
        }
    }

    private String getMappingKey(ApiInfo info) {
        return MappingHandlerMapping.buildMappingKey(info.getMethod(), this.getRequestPath(info.getGroupId(), info.getPath()));
    }

    public String getRequestPath(String groupId, String path) {
        return this.concatPath(this.groupServiceProvider.getFullPath(groupId), path);
    }

    public void registerController(Object target, String base) {
        Method[] methods;
        for (Method method : methods = target.getClass().getDeclaredMethods()) {
            RequestMapping requestMapping = method.getAnnotation(RequestMapping.class);
            if (requestMapping == null) continue;
            String[] paths = (String[])Stream.of(requestMapping.value()).map(value -> base + value).toArray(String[]::new);
            this.mappingHelper.register(RequestMappingInfo.paths((String[])paths).build(), target, method);
        }
    }

    private String concatPath(String groupPath, String path) {
        path = groupPath + "/" + path;
        if (this.prefix != null) {
            path = this.prefix + "/" + path;
        }
        if ((path = PathUtils.replaceSlash(path)).startsWith("/")) {
            return path.substring(1);
        }
        return path;
    }

    private boolean overrideApplicationMapping(RequestMappingInfo requestMapping) {
        if (this.mappingHelper.getHandlerMethods().containsKey(requestMapping)) {
            if (!this.allowOverride) {
                return false;
            }
            logger.warn("\u53d6\u6d88\u6ce8\u518c\u5e94\u7528\u63a5\u53e3:{}", (Object)requestMapping);
            this.mappingHelper.unregister(requestMapping);
        }
        return true;
    }

    private RequestMappingInfo getRequestMapping(ApiInfo info) {
        return RequestMappingInfo.paths((String[])new String[]{this.getRequestPath(info.getGroupId(), info.getPath())}).methods(new RequestMethod[]{RequestMethod.valueOf((String)info.getMethod().toUpperCase())}).build();
    }

    private RequestMappingInfo getRequestMapping(String method, String path) {
        return RequestMappingInfo.paths((String[])new String[]{path}).methods(new RequestMethod[]{RequestMethod.valueOf((String)method.toUpperCase())}).build();
    }

    public void enableRefresh(int interval) {
        if (interval > 0) {
            logger.info("\u542f\u52a8\u81ea\u52a8\u5237\u65b0magic-api");
            Executors.newScheduledThreadPool(1).scheduleAtFixedRate(this::registerAllMapping, interval, interval, TimeUnit.SECONDS);
        }
    }

    static class MappingNode {
        private ApiInfo info;
        private String mappingKey;
        private RequestMappingInfo requestMappingInfo;

        public MappingNode(ApiInfo info) {
            this.info = info;
        }

        public ApiInfo getInfo() {
            return this.info;
        }

        public void setInfo(ApiInfo info) {
            this.info = info;
        }

        public String getMappingKey() {
            return this.mappingKey;
        }

        public void setMappingKey(String mappingKey) {
            this.mappingKey = mappingKey;
        }

        public RequestMappingInfo getRequestMappingInfo() {
            return this.requestMappingInfo;
        }

        public void setRequestMappingInfo(RequestMappingInfo requestMappingInfo) {
            this.requestMappingInfo = requestMappingInfo;
        }
    }
}

