/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.config;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ssssssss.magicapi.model.FunctionInfo;
import org.ssssssss.magicapi.model.Group;
import org.ssssssss.magicapi.model.Parameter;
import org.ssssssss.magicapi.model.TreeNode;
import org.ssssssss.magicapi.provider.FunctionServiceProvider;
import org.ssssssss.magicapi.provider.GroupServiceProvider;
import org.ssssssss.magicapi.script.ScriptManager;
import org.ssssssss.magicapi.utils.PathUtils;
import org.ssssssss.script.MagicResourceLoader;
import org.ssssssss.script.MagicScriptContext;

public class MagicFunctionManager {
    private static final Logger logger = LoggerFactory.getLogger(MagicFunctionManager.class);
    private static Map<String, FunctionInfo> mappings = new ConcurrentHashMap<String, FunctionInfo>();
    private GroupServiceProvider groupServiceProvider;
    private FunctionServiceProvider functionServiceProvider;
    private TreeNode<Group> groups;

    public MagicFunctionManager(GroupServiceProvider groupServiceProvider, FunctionServiceProvider functionServiceProvider) {
        this.groupServiceProvider = groupServiceProvider;
        this.functionServiceProvider = functionServiceProvider;
    }

    public void registerFunctionLoader() {
        MagicResourceLoader.addFunctionLoader(path -> {
            FunctionInfo info = mappings.get(path);
            if (info != null) {
                List<Parameter> parameters = info.getParameters();
                return objects -> {
                    MagicScriptContext context = MagicScriptContext.get();
                    try {
                        MagicScriptContext functionContext = new MagicScriptContext(context.getRootVariables());
                        MagicScriptContext.set((MagicScriptContext)functionContext);
                        if (objects != null) {
                            int len = ((Object[])objects).length;
                            int size = parameters.size();
                            for (int i = 0; i < len && i < size; ++i) {
                                functionContext.set(((Parameter)parameters.get(i)).getName(), objects[i]);
                            }
                        }
                        Object object = ScriptManager.executeScript(info.getScript(), functionContext);
                        return object;
                    }
                    finally {
                        MagicScriptContext.set((MagicScriptContext)context);
                    }
                };
            }
            return null;
        });
    }

    public synchronized void loadGroup() {
        this.groups = this.groupServiceProvider.functionGroupTree();
    }

    public void registerAllFunction() {
        this.loadGroup();
        this.functionServiceProvider.listWithScript().stream().filter(it -> this.groupServiceProvider.getFullPath(it.getGroupId()) != null).forEach(this::register);
    }

    public boolean hasRegister(FunctionInfo info) {
        String path = PathUtils.replaceSlash(Objects.toString(this.groupServiceProvider.getFullPath(info.getGroupId()), "") + "/" + info.getPath());
        FunctionInfo functionInfo = mappings.get(path);
        return functionInfo != null && !Objects.equals(info.getId(), functionInfo.getId());
    }

    public boolean hasRegister(Set<String> paths) {
        return paths.stream().anyMatch(mappings::containsKey);
    }

    public boolean move(String id, String groupId) {
        FunctionInfo info = mappings.get(id);
        if (info == null) {
            return false;
        }
        String path = Objects.toString(this.groupServiceProvider.getFullPath(groupId), "");
        FunctionInfo functionInfo = mappings.get(PathUtils.replaceSlash(path + "/" + info.getPath()));
        if (functionInfo != null && !Objects.equals(functionInfo.getId(), id)) {
            return false;
        }
        this.unregister(id);
        info.setGroupId(groupId);
        this.register(info);
        return true;
    }

    public void register(FunctionInfo functionInfo) {
        FunctionInfo oldFunctionInfo = mappings.get(functionInfo.getId());
        if (oldFunctionInfo != null) {
            if (functionInfo.equals(oldFunctionInfo)) {
                return;
            }
            if (!Objects.equals(functionInfo.getPath(), oldFunctionInfo.getPath())) {
                this.unregister(functionInfo.getId());
            }
        }
        String path = Objects.toString(this.groupServiceProvider.getFullPath(functionInfo.getGroupId()), "");
        mappings.put(functionInfo.getId(), functionInfo);
        path = PathUtils.replaceSlash(path + "/" + functionInfo.getPath());
        functionInfo.setMappingPath(path);
        mappings.put(path, functionInfo);
        logger.info("\u6ce8\u518c\u51fd\u6570:[{}:{}]", (Object)functionInfo.getName(), (Object)path);
    }

    public Collection<FunctionInfo> getFunctionInfos() {
        return mappings.values();
    }

    private boolean hasConflict(TreeNode<Group> group, String newPath) {
        List infos = mappings.values().stream().filter(info -> Objects.equals(info.getGroupId(), ((Group)group.getNode()).getId())).distinct().collect(Collectors.toList());
        for (FunctionInfo functionInfo : infos) {
            if (!mappings.containsKey(PathUtils.replaceSlash(newPath + "/" + functionInfo.getPath()))) continue;
            return true;
        }
        for (TreeNode treeNode : group.getChildren()) {
            if (!this.hasConflict(treeNode, newPath + "/" + Objects.toString(((Group)treeNode.getNode()).getPath(), ""))) continue;
            return true;
        }
        return false;
    }

    public boolean checkGroup(Group group) {
        TreeNode<Group> oldTree = this.groups.findTreeNode(item -> item.getId().equals(group.getId()));
        if (Objects.equals(oldTree.getNode().getParentId(), group.getParentId()) && Objects.equals(oldTree.getNode().getPath(), group.getPath())) {
            return true;
        }
        String newPath = Objects.toString(this.groupServiceProvider.getFullPath(group.getParentId()), "");
        return !this.hasConflict(oldTree, newPath + "/" + Objects.toString(group.getPath(), ""));
    }

    private void recurseUpdateGroup(TreeNode<Group> node, boolean updateGroupId) {
        mappings.values().stream().filter(info -> Objects.equals(info.getGroupId(), ((Group)node.getNode()).getId())).distinct().collect(Collectors.toList()).forEach(info -> {
            this.unregister(info.getId());
            if (updateGroupId) {
                info.setGroupId(((Group)node.getNode()).getId());
            }
            this.register((FunctionInfo)info);
        });
        for (TreeNode<Group> child : node.getChildren()) {
            this.recurseUpdateGroup(child, false);
        }
    }

    public void updateGroup(Group group) {
        this.loadGroup();
        TreeNode<Group> groupTreeNode = this.groups.findTreeNode(item -> item.getId().equals(group.getId()));
        this.recurseUpdateGroup(groupTreeNode, true);
    }

    public void deleteGroup(List<String> groupIds) {
        mappings.values().stream().filter(info -> groupIds.contains(info.getGroupId())).distinct().collect(Collectors.toList()).forEach(info -> this.unregister(info.getId()));
    }

    public void unregister(String id) {
        FunctionInfo functionInfo = mappings.remove(id);
        if (functionInfo != null) {
            mappings.remove(functionInfo.getMappingPath());
            logger.info("\u53d6\u6d88\u6ce8\u518c\u51fd\u6570:[{},{}]", (Object)functionInfo.getName(), (Object)functionInfo.getMappingPath());
        }
    }

    public void enableRefresh(int interval) {
        if (interval > 0) {
            Executors.newScheduledThreadPool(1).scheduleAtFixedRate(this::registerAllFunction, interval, interval, TimeUnit.SECONDS);
        }
    }
}

