/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.cache;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.ssssssss.magicapi.cache.SqlCache;

public class DefaultSqlCache
extends LinkedHashMap<String, ExpireNode<Object>>
implements SqlCache {
    private final String separator = ":";
    private final int capacity;
    private final long expire;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public DefaultSqlCache(int capacity, long expire) {
        super((int)Math.ceil((double)capacity / 0.75) + 1, 0.75f, true);
        this.capacity = capacity;
        this.expire = expire;
    }

    @Override
    public void put(String name, String key, Object value) {
        this.put(name, key, value, this.expire);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String name, String key, Object value, long ttl) {
        long expireTime = ttl > 0L ? System.currentTimeMillis() + ttl : (this.expire > -1L ? System.currentTimeMillis() + this.expire : Long.MAX_VALUE);
        this.lock.writeLock().lock();
        try {
            this.put(name + ":" + key, new ExpireNode<Object>(expireTime, value));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String name, String key) {
        ExpireNode expireNode;
        key = name + ":" + key;
        this.lock.readLock().lock();
        try {
            expireNode = (ExpireNode)super.get(key);
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (expireNode == null) {
            return null;
        }
        if (expireNode.expire < System.currentTimeMillis()) {
            try {
                this.lock.writeLock().lock();
                super.remove(key);
            }
            finally {
                this.lock.writeLock().unlock();
            }
            return null;
        }
        return expireNode.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String name) {
        try {
            this.lock.writeLock().lock();
            Iterator iterator = super.entrySet().iterator();
            String prefix = name + ":";
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!((String)entry.getKey()).startsWith(prefix)) continue;
                iterator.remove();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<String, ExpireNode<Object>> eldest) {
        if (this.expire > -1L && this.size() > this.capacity) {
            this.clean();
        }
        return this.size() > this.capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clean() {
        try {
            this.lock.writeLock().lock();
            Iterator iterator = super.entrySet().iterator();
            long now = System.currentTimeMillis();
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                if (((ExpireNode)next.getValue()).expire >= now) continue;
                iterator.remove();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    static class ExpireNode<V> {
        long expire;
        V value;

        ExpireNode(long expire, V value) {
            this.expire = expire;
            this.value = value;
        }
    }
}

