/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.adapter.resource;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.ssssssss.magicapi.adapter.Resource;

public class ZipResource
implements Resource {
    private final Map<String, byte[]> cachedContent;
    private String path = "";
    private Resource parent;

    public ZipResource(InputStream is) throws IOException {
        this.cachedContent = new HashMap<String, byte[]>();
        try (ZipArchiveInputStream zis = new ZipArchiveInputStream(is);){
            ArchiveEntry entry;
            byte[] buf = new byte[4096];
            int len = -1;
            while ((entry = zis.getNextEntry()) != null) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                while ((len = zis.read(buf, 0, buf.length)) != -1) {
                    os.write(buf, 0, len);
                }
                this.cachedContent.put(entry.getName(), os.toByteArray());
            }
        }
    }

    ZipResource(String name, Map<String, byte[]> cachedContent, Resource parent) {
        this.path = name;
        this.cachedContent = cachedContent;
        this.parent = parent;
    }

    @Override
    public boolean readonly() {
        return true;
    }

    @Override
    public boolean exists() {
        return this.cachedContent.containsKey(this.path);
    }

    @Override
    public byte[] read() {
        return this.cachedContent.getOrDefault(this.path, new byte[0]);
    }

    @Override
    public Resource getResource(String name) {
        return new ZipResource(this.path + name, this.cachedContent, this);
    }

    @Override
    public Resource getDirectory(String name) {
        return new ZipResource(this.path + name + "/", this.cachedContent, this);
    }

    @Override
    public boolean isDirectory() {
        return this.path.isEmpty() || this.path.endsWith("/");
    }

    @Override
    public String name() {
        int index;
        String name = this.path;
        if (this.isDirectory()) {
            name = this.path.substring(0, name.length() - 1);
        }
        return (index = name.lastIndexOf("/")) > -1 ? name.substring(index + 1) : name;
    }

    @Override
    public List<Resource> resources() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Resource parent() {
        return this.parent;
    }

    @Override
    public List<Resource> dirs() {
        int len = this.path.length();
        return this.cachedContent.keySet().stream().filter(it -> it.endsWith("/") && it.startsWith(this.path) && it.indexOf("/", len + 1) == it.length() - 1).map(it -> this.getDirectory(it.substring(len, it.length() - 1))).collect(Collectors.toList());
    }

    @Override
    public List<Resource> files(String suffix) {
        if (this.isDirectory()) {
            int len = this.path.length();
            return this.cachedContent.keySet().stream().filter(it -> it.startsWith(this.path) && it.endsWith(suffix) && it.indexOf("/", len) == -1).map(it -> this.getResource(it.substring(len))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public String getAbsolutePath() {
        return this.path;
    }
}

