/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.adapter.resource;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.ssssssss.magicapi.adapter.Resource;
import org.ssssssss.magicapi.adapter.resource.KeyValueResource;

public class RedisResource
extends KeyValueResource {
    private static final Logger logger = LoggerFactory.getLogger(RedisResource.class);
    private final StringRedisTemplate redisTemplate;
    private final Map<String, String> cachedContent = new ConcurrentHashMap<String, String>();

    public RedisResource(StringRedisTemplate redisTemplate, String path, boolean readonly, RedisResource parent) {
        super(":", path, readonly, parent);
        this.redisTemplate = redisTemplate;
    }

    public RedisResource(StringRedisTemplate redisTemplate, String path, boolean readonly) {
        this(redisTemplate, path, readonly, null);
    }

    @Override
    public void readAll() {
        this.cachedContent.clear();
        ArrayList<String> keys = new ArrayList<String>(this.keys());
        List values = this.redisTemplate.opsForValue().multiGet(keys);
        if (values != null) {
            int size = keys.size();
            for (int i = 0; i < size; ++i) {
                this.cachedContent.put((String)keys.get(i), (String)values.get(i));
            }
        }
    }

    @Override
    public byte[] read() {
        String value = this.cachedContent.get(this.path);
        if (value == null) {
            value = (String)this.redisTemplate.opsForValue().get((Object)this.path);
        }
        return value == null ? new byte[]{} : value.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public boolean write(String content) {
        this.redisTemplate.opsForValue().set((Object)this.path, (Object)content);
        this.cachedContent.put(this.path, content);
        return true;
    }

    @Override
    protected boolean renameTo(Map<String, String> renameKeys) {
        renameKeys.forEach((arg_0, arg_1) -> ((StringRedisTemplate)this.redisTemplate).rename(arg_0, arg_1));
        renameKeys.forEach((oldKey, newKey) -> this.cachedContent.put((String)newKey, this.cachedContent.remove(oldKey)));
        return true;
    }

    @Override
    public boolean exists() {
        if (this.cachedContent.containsKey(this.path)) {
            return true;
        }
        return Boolean.TRUE.equals(this.redisTemplate.hasKey((Object)this.path));
    }

    @Override
    protected boolean deleteByKey(String key) {
        if (Boolean.TRUE.equals(this.redisTemplate.delete((Object)key))) {
            this.cachedContent.remove(key);
            return true;
        }
        return false;
    }

    @Override
    protected Function<String, Resource> mappedFunction() {
        return it -> new RedisResource(this.redisTemplate, (String)it, this.readonly, this);
    }

    @Override
    protected Set<String> keys() {
        Set keys = (Set)this.redisTemplate.execute(connection -> {
            ScanOptions options = new ScanOptions.ScanOptionsBuilder().count(Long.MAX_VALUE).match((this.isDirectory() ? this.path : this.path + this.separator) + "*").build();
            HashSet<String> returnKeys = new HashSet<String>();
            try (Cursor cursor = connection.scan(options);){
                while (cursor.hasNext()) {
                    returnKeys.add(new String((byte[])cursor.next()));
                }
            }
            catch (IOException e) {
                logger.error("\u626b\u63cfkey\u51fa\u9519", (Throwable)e);
            }
            return returnKeys;
        });
        return keys == null ? Collections.emptySet() : keys;
    }

    public String toString() {
        return String.format("redis://%s", this.getAbsolutePath());
    }
}

