/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.springframework.expression.spel.SpelCompilerMode;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.statemachine.action.Action;
import org.springframework.statemachine.action.SpelExpressionAction;
import org.springframework.statemachine.config.model.AbstractStateMachineModelFactory;
import org.springframework.statemachine.config.model.ChoiceData;
import org.springframework.statemachine.config.model.DefaultStateMachineModel;
import org.springframework.statemachine.config.model.EntryData;
import org.springframework.statemachine.config.model.ExitData;
import org.springframework.statemachine.config.model.HistoryData;
import org.springframework.statemachine.config.model.JunctionData;
import org.springframework.statemachine.config.model.StateData;
import org.springframework.statemachine.config.model.StateMachineModel;
import org.springframework.statemachine.config.model.StateMachineModelFactory;
import org.springframework.statemachine.config.model.StatesData;
import org.springframework.statemachine.config.model.TransitionData;
import org.springframework.statemachine.config.model.TransitionsData;
import org.springframework.statemachine.data.RepositoryAction;
import org.springframework.statemachine.data.RepositoryGuard;
import org.springframework.statemachine.data.RepositoryState;
import org.springframework.statemachine.data.RepositoryTransition;
import org.springframework.statemachine.data.StateRepository;
import org.springframework.statemachine.data.TransitionRepository;
import org.springframework.statemachine.guard.Guard;
import org.springframework.statemachine.guard.SpelExpressionGuard;
import org.springframework.statemachine.state.PseudoStateKind;
import org.springframework.statemachine.transition.TransitionKind;
import org.springframework.util.StringUtils;

public class RepositoryStateMachineModelFactory
extends AbstractStateMachineModelFactory<String, String>
implements StateMachineModelFactory<String, String> {
    private final StateRepository<? extends RepositoryState> stateRepository;
    private final TransitionRepository<? extends RepositoryTransition> transitionRepository;

    public RepositoryStateMachineModelFactory(StateRepository<? extends RepositoryState> stateRepository, TransitionRepository<? extends RepositoryTransition> transitionRepository) {
        this.stateRepository = stateRepository;
        this.transitionRepository = transitionRepository;
    }

    public StateMachineModel<String, String> build() {
        return this.build(null);
    }

    /*
     * WARNING - void declaration
     */
    public StateMachineModel<String, String> build(String machineId) {
        ArrayList<StateData> stateDatas = new ArrayList<StateData>();
        for (RepositoryState repositoryState : this.stateRepository.findByMachineId(machineId == null ? "" : machineId)) {
            StateMachineModel<String, String> subStateMachineModel = null;
            String submachineId = repositoryState.getSubmachineId();
            if (submachineId != null) {
                subStateMachineModel = this.build(submachineId);
            }
            ArrayList<Object> stateActions = new ArrayList<Object>();
            Set<? extends RepositoryAction> repositoryStateActions = repositoryState.getStateActions();
            if (repositoryStateActions != null) {
                for (RepositoryAction repositoryAction : repositoryStateActions) {
                    Action action = null;
                    if (StringUtils.hasText((String)repositoryAction.getName())) {
                        action = this.resolveAction(repositoryAction.getName());
                    } else if (StringUtils.hasText((String)repositoryAction.getSpel())) {
                        SpelExpressionParser spelExpressionParser = new SpelExpressionParser(new SpelParserConfiguration(SpelCompilerMode.MIXED, null));
                        action = new SpelExpressionAction(spelExpressionParser.parseExpression(repositoryAction.getSpel()));
                    }
                    if (action == null) continue;
                    stateActions.add(action);
                }
            }
            ArrayList entryActions = new ArrayList();
            Set<? extends RepositoryAction> set = repositoryState.getEntryActions();
            if (set != null) {
                for (RepositoryAction repositoryAction : set) {
                    void var13_28;
                    Object var13_25 = null;
                    if (StringUtils.hasText((String)repositoryAction.getName())) {
                        Action action = this.resolveAction(repositoryAction.getName());
                    } else if (StringUtils.hasText((String)repositoryAction.getSpel())) {
                        SpelExpressionParser spelExpressionParser = new SpelExpressionParser(new SpelParserConfiguration(SpelCompilerMode.MIXED, null));
                        SpelExpressionAction spelExpressionAction = new SpelExpressionAction(spelExpressionParser.parseExpression(repositoryAction.getSpel()));
                    }
                    if (var13_28 == null) continue;
                    stateActions.add(var13_28);
                }
            }
            ArrayList exitActions = new ArrayList();
            Set<? extends RepositoryAction> set2 = repositoryState.getExitActions();
            if (set2 != null) {
                for (RepositoryAction repositoryAction : set2) {
                    Action action = null;
                    if (StringUtils.hasText((String)repositoryAction.getName())) {
                        action = this.resolveAction(repositoryAction.getName());
                    } else if (StringUtils.hasText((String)repositoryAction.getSpel())) {
                        SpelExpressionParser parser = new SpelExpressionParser(new SpelParserConfiguration(SpelCompilerMode.MIXED, null));
                        action = new SpelExpressionAction(parser.parseExpression(repositoryAction.getSpel()));
                    }
                    if (action == null) continue;
                    stateActions.add(action);
                }
            }
            RepositoryState repositoryState2 = repositoryState.getParentState();
            String string = repositoryState.getRegion();
            StateData stateData = new StateData((Object)(repositoryState2 != null ? repositoryState2.getState() : null), (Object)string, (Object)repositoryState.getState(), repositoryState.isInitial().booleanValue());
            Action initialAction = null;
            if (repositoryState.getInitialAction() != null) {
                if (StringUtils.hasText((String)repositoryState.getInitialAction().getName())) {
                    initialAction = this.resolveAction(repositoryState.getInitialAction().getName());
                } else if (StringUtils.hasText((String)repositoryState.getInitialAction().getSpel())) {
                    SpelExpressionParser spelExpressionParser = new SpelExpressionParser(new SpelParserConfiguration(SpelCompilerMode.MIXED, null));
                    initialAction = new SpelExpressionAction(spelExpressionParser.parseExpression(repositoryState.getInitialAction().getSpel()));
                }
            }
            stateData.setInitialAction(initialAction);
            stateData.setStateActions(stateActions);
            stateData.setEntryActions(entryActions);
            stateData.setExitActions(exitActions);
            if (repositoryState.getKind() != null) {
                stateData.setPseudoStateKind(repositoryState.getKind());
                if (repositoryState.getKind() == PseudoStateKind.END) {
                    stateData.setEnd(true);
                }
            }
            stateData.setDeferred(repositoryState.getDeferredEvents());
            if (subStateMachineModel != null) {
                ArrayList<StateData> arrayList = new ArrayList<StateData>();
                Collection submachineStateDataOrig = subStateMachineModel.getStatesData().getStateData();
                for (StateData sd : submachineStateDataOrig) {
                    arrayList.add(new StateData((Object)repositoryState.getState(), sd.getRegion(), sd.getState(), sd.getDeferred(), sd.getEntryActions(), sd.getExitActions(), sd.isInitial(), sd.getInitialAction()));
                }
                stateData.setSubmachineStateData(arrayList);
            }
            stateDatas.add(stateData);
        }
        StatesData statesData = new StatesData(stateDatas);
        ArrayList<TransitionData> arrayList = new ArrayList<TransitionData>();
        ArrayList<EntryData> entrys = new ArrayList<EntryData>();
        ArrayList<ExitData> exits = new ArrayList<ExitData>();
        ArrayList<HistoryData> historys = new ArrayList<HistoryData>();
        HashMap choices = new HashMap();
        HashMap junctions = new HashMap();
        HashMap hashMap = new HashMap();
        HashMap joins = new HashMap();
        for (RepositoryTransition repositoryTransition : this.transitionRepository.findByMachineId(machineId == null ? "" : machineId)) {
            List<Object> list;
            ArrayList<Action> arrayList2 = new ArrayList<Action>();
            Set<? extends RepositoryAction> repositoryActions = repositoryTransition.getActions();
            if (repositoryActions != null) {
                for (RepositoryAction repositoryAction : repositoryActions) {
                    Action action = null;
                    if (StringUtils.hasText((String)repositoryAction.getName())) {
                        action = this.resolveAction(repositoryAction.getName());
                    } else if (StringUtils.hasText((String)repositoryAction.getSpel())) {
                        SpelExpressionParser parser = new SpelExpressionParser(new SpelParserConfiguration(SpelCompilerMode.MIXED, null));
                        action = new SpelExpressionAction(parser.parseExpression(repositoryAction.getSpel()));
                    }
                    if (action == null) continue;
                    arrayList2.add(action);
                }
            }
            TransitionKind kind = repositoryTransition.getKind();
            Guard<String, String> guard = this.resolveGuard(repositoryTransition);
            arrayList.add(new TransitionData((Object)repositoryTransition.getSource().getState(), (Object)repositoryTransition.getTarget().getState(), (Object)repositoryTransition.getEvent(), arrayList2, guard, kind != null ? kind : TransitionKind.EXTERNAL));
            if (repositoryTransition.getSource().getKind() == PseudoStateKind.ENTRY) {
                entrys.add(new EntryData((Object)repositoryTransition.getSource().getState(), (Object)repositoryTransition.getTarget().getState()));
                continue;
            }
            if (repositoryTransition.getSource().getKind() == PseudoStateKind.EXIT) {
                exits.add(new ExitData((Object)repositoryTransition.getSource().getState(), (Object)repositoryTransition.getTarget().getState()));
                continue;
            }
            if (repositoryTransition.getSource().getKind() == PseudoStateKind.CHOICE) {
                Guard<String, String> guard2;
                list = (LinkedList<ChoiceData>)choices.get(repositoryTransition.getSource().getState());
                if (list == null) {
                    list = new LinkedList<ChoiceData>();
                    choices.put(repositoryTransition.getSource().getState(), list);
                }
                if ((guard2 = this.resolveGuard(repositoryTransition)) == null) {
                    list.addLast(new ChoiceData((Object)repositoryTransition.getSource().getState(), (Object)repositoryTransition.getTarget().getState(), guard2));
                    continue;
                }
                list.addFirst(new ChoiceData((Object)repositoryTransition.getSource().getState(), (Object)repositoryTransition.getTarget().getState(), guard2));
                continue;
            }
            if (repositoryTransition.getSource().getKind() == PseudoStateKind.JUNCTION) {
                Guard<String, String> guard3;
                list = (LinkedList)junctions.get(repositoryTransition.getSource().getState());
                if (list == null) {
                    list = new LinkedList();
                    junctions.put(repositoryTransition.getSource().getState(), list);
                }
                if ((guard3 = this.resolveGuard(repositoryTransition)) == null) {
                    list.addLast((ChoiceData)new JunctionData((Object)repositoryTransition.getSource().getState(), (Object)repositoryTransition.getTarget().getState(), guard3));
                    continue;
                }
                list.addFirst((ChoiceData)new JunctionData((Object)repositoryTransition.getSource().getState(), (Object)repositoryTransition.getTarget().getState(), guard3));
                continue;
            }
            if (repositoryTransition.getSource().getKind() == PseudoStateKind.FORK) {
                list = (List)hashMap.get(repositoryTransition.getSource().getState());
                if (list == null) {
                    list = new ArrayList();
                    hashMap.put(repositoryTransition.getSource().getState(), list);
                }
                list.add((ChoiceData)repositoryTransition.getTarget().getState());
                continue;
            }
            if (repositoryTransition.getTarget().getKind() == PseudoStateKind.JOIN) {
                list = (List)joins.get(repositoryTransition.getTarget().getState());
                if (list == null) {
                    list = new ArrayList();
                    joins.put(repositoryTransition.getTarget().getState(), list);
                }
                list.add((ChoiceData)repositoryTransition.getSource().getState());
                continue;
            }
            if (repositoryTransition.getSource().getKind() == PseudoStateKind.HISTORY_SHALLOW) {
                historys.add(new HistoryData((Object)repositoryTransition.getSource().getState(), (Object)repositoryTransition.getTarget().getState()));
                continue;
            }
            if (repositoryTransition.getSource().getKind() != PseudoStateKind.HISTORY_DEEP) continue;
            historys.add(new HistoryData((Object)repositoryTransition.getSource().getState(), (Object)repositoryTransition.getTarget().getState()));
        }
        HashMap hashMap2 = new HashMap();
        hashMap2.putAll(choices);
        HashMap hashMap3 = new HashMap();
        hashMap3.putAll(junctions);
        TransitionsData transitionsData = new TransitionsData(arrayList, hashMap2, hashMap3, hashMap, joins, entrys, exits, historys);
        return new DefaultStateMachineModel(null, statesData, transitionsData);
    }

    private Guard<String, String> resolveGuard(RepositoryTransition t) {
        Guard guard = null;
        RepositoryGuard repositoryGuard = t.getGuard();
        if (repositoryGuard != null) {
            if (StringUtils.hasText((String)repositoryGuard.getName())) {
                guard = this.resolveGuard(repositoryGuard.getName());
            } else if (StringUtils.hasText((String)repositoryGuard.getSpel())) {
                SpelExpressionParser parser = new SpelExpressionParser(new SpelParserConfiguration(SpelCompilerMode.MIXED, null));
                guard = new SpelExpressionGuard(parser.parseExpression(repositoryGuard.getSpel()));
            }
        }
        return guard;
    }
}

