/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;
import org.springframework.web.cors.reactive.CorsUtils;
import org.springframework.web.cors.reactive.PreFlightRequestHandler;
import org.springframework.web.reactive.HandlerAdapter;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.HandlerResultHandler;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebHandler;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DispatcherHandler
implements WebHandler,
PreFlightRequestHandler,
ApplicationContextAware {
    @Nullable
    private List<HandlerMapping> handlerMappings;
    @Nullable
    private List<HandlerAdapter> handlerAdapters;
    @Nullable
    private List<HandlerResultHandler> resultHandlers;

    public DispatcherHandler() {
    }

    public DispatcherHandler(ApplicationContext applicationContext) {
        this.initStrategies(applicationContext);
    }

    @Nullable
    public final List<HandlerMapping> getHandlerMappings() {
        return this.handlerMappings;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.initStrategies(applicationContext);
    }

    protected void initStrategies(ApplicationContext context) {
        Map mappingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, HandlerMapping.class, (boolean)true, (boolean)false);
        ArrayList mappings = new ArrayList(mappingBeans.values());
        AnnotationAwareOrderComparator.sort(mappings);
        this.handlerMappings = Collections.unmodifiableList(mappings);
        Map adapterBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, HandlerAdapter.class, (boolean)true, (boolean)false);
        this.handlerAdapters = new ArrayList(adapterBeans.values());
        AnnotationAwareOrderComparator.sort(this.handlerAdapters);
        Map beans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, HandlerResultHandler.class, (boolean)true, (boolean)false);
        this.resultHandlers = new ArrayList(beans.values());
        AnnotationAwareOrderComparator.sort(this.resultHandlers);
    }

    public Mono<Void> handle(ServerWebExchange exchange) {
        if (this.handlerMappings == null) {
            return this.createNotFoundError();
        }
        if (CorsUtils.isPreFlightRequest((ServerHttpRequest)exchange.getRequest())) {
            return this.handlePreFlight(exchange);
        }
        return Flux.fromIterable(this.handlerMappings).concatMap(mapping -> mapping.getHandler(exchange)).next().switchIfEmpty(this.createNotFoundError()).flatMap(handler -> this.invokeHandler(exchange, handler)).flatMap(result -> this.handleResult(exchange, (HandlerResult)result));
    }

    private <R> Mono<R> createNotFoundError() {
        return Mono.defer(() -> {
            ResponseStatusException ex = new ResponseStatusException(HttpStatus.NOT_FOUND, "No matching handler");
            return Mono.error((Throwable)ex);
        });
    }

    private Mono<HandlerResult> invokeHandler(ServerWebExchange exchange, Object handler) {
        if (ObjectUtils.nullSafeEquals((Object)exchange.getResponse().getStatusCode(), (Object)HttpStatus.FORBIDDEN)) {
            return Mono.empty();
        }
        if (this.handlerAdapters != null) {
            for (HandlerAdapter handlerAdapter : this.handlerAdapters) {
                if (!handlerAdapter.supports(handler)) continue;
                return handlerAdapter.handle(exchange, handler);
            }
        }
        return Mono.error((Throwable)new IllegalStateException("No HandlerAdapter: " + handler));
    }

    private Mono<Void> handleResult(ServerWebExchange exchange, HandlerResult result) {
        return this.getResultHandler(result).handleResult(exchange, result).checkpoint("Handler " + result.getHandler() + " [DispatcherHandler]").onErrorResume(ex -> result.applyExceptionHandler((Throwable)ex).flatMap(exResult -> {
            String text = "Exception handler " + exResult.getHandler() + ", error=\"" + ex.getMessage() + "\" [DispatcherHandler]";
            return this.getResultHandler((HandlerResult)exResult).handleResult(exchange, (HandlerResult)exResult).checkpoint(text);
        }));
    }

    private HandlerResultHandler getResultHandler(HandlerResult handlerResult) {
        if (this.resultHandlers != null) {
            for (HandlerResultHandler resultHandler : this.resultHandlers) {
                if (!resultHandler.supports(handlerResult)) continue;
                return resultHandler;
            }
        }
        throw new IllegalStateException("No HandlerResultHandler for " + handlerResult.getReturnValue());
    }

    public Mono<Void> handlePreFlight(ServerWebExchange exchange) {
        return Flux.fromIterable(this.handlerMappings != null ? this.handlerMappings : Collections.emptyList()).concatMap(mapping -> mapping.getHandler(exchange)).switchIfEmpty((Publisher)Mono.fromRunnable(() -> exchange.getResponse().setStatusCode(HttpStatus.FORBIDDEN))).next().then();
    }
}

