/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.vendor;

import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.spi.PersistenceUnitInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.jpa.HibernatePersistenceProvider;
import org.hibernate.jpa.boot.internal.EntityManagerFactoryBuilderImpl;
import org.hibernate.jpa.boot.internal.PersistenceUnitInfoDescriptor;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.springframework.core.NativeDetector;
import org.springframework.orm.jpa.persistenceunit.SmartPersistenceUnitInfo;

class SpringHibernateJpaPersistenceProvider
extends HibernatePersistenceProvider {
    SpringHibernateJpaPersistenceProvider() {
    }

    public EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo info, Map properties) {
        final ArrayList<String> mergedClassesAndPackages = new ArrayList<String>(info.getManagedClassNames());
        if (info instanceof SmartPersistenceUnitInfo) {
            mergedClassesAndPackages.addAll(((SmartPersistenceUnitInfo)info).getManagedPackages());
        }
        return new EntityManagerFactoryBuilderImpl((PersistenceUnitDescriptor)new PersistenceUnitInfoDescriptor(info){

            public List<String> getManagedClassNames() {
                return mergedClassesAndPackages;
            }
        }, properties).build();
    }

    static {
        if (NativeDetector.inNativeImage()) {
            System.setProperty("hibernate.bytecode.provider", "none");
        }
    }
}

