/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.KeySourceException;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.springframework.security.oauth2.jwt.ReactiveRemoteJWKSource;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

final class ReactiveJwtDecoderProviderConfigurationUtils {
    static <C extends SecurityContext> Mono<ConfigurableJWTProcessor<C>> addJWSAlgorithms(ReactiveRemoteJWKSource jwkSource, ConfigurableJWTProcessor<C> jwtProcessor) {
        JWSKeySelector selector = jwtProcessor.getJWSKeySelector();
        if (!(selector instanceof JWSVerificationKeySelector)) {
            return Mono.just(jwtProcessor);
        }
        JWKSource delegate = ((JWSVerificationKeySelector)selector).getJWKSource();
        return ReactiveJwtDecoderProviderConfigurationUtils.getJWSAlgorithms(jwkSource).map(algorithms -> new JWSVerificationKeySelector(algorithms, delegate)).map(replacement -> {
            jwtProcessor.setJWSKeySelector((JWSKeySelector)replacement);
            return jwtProcessor;
        });
    }

    static Mono<Set<JWSAlgorithm>> getJWSAlgorithms(ReactiveRemoteJWKSource jwkSource) {
        JWKMatcher jwkMatcher = new JWKMatcher.Builder().publicOnly(true).keyUses(new KeyUse[]{KeyUse.SIGNATURE, null}).keyTypes(new KeyType[]{KeyType.RSA, KeyType.EC}).build();
        return jwkSource.get(new JWKSelector(jwkMatcher)).map(jwks -> {
            HashSet<JWSAlgorithm> jwsAlgorithms = new HashSet<JWSAlgorithm>();
            for (JWK jwk : jwks) {
                if (jwk.getAlgorithm() != null) {
                    JWSAlgorithm jwsAlgorithm = JWSAlgorithm.parse((String)jwk.getAlgorithm().getName());
                    jwsAlgorithms.add(jwsAlgorithm);
                    continue;
                }
                if (jwk.getKeyType() == KeyType.RSA) {
                    jwsAlgorithms.addAll((Collection<JWSAlgorithm>)JWSAlgorithm.Family.RSA);
                    continue;
                }
                if (jwk.getKeyType() != KeyType.EC) continue;
                jwsAlgorithms.addAll((Collection<JWSAlgorithm>)JWSAlgorithm.Family.EC);
            }
            Assert.notEmpty(jwsAlgorithms, (String)"Failed to find any algorithms from the JWK set");
            return jwsAlgorithms;
        }).onErrorMap(KeySourceException.class, ex -> new IllegalStateException((Throwable)ex));
    }

    private ReactiveJwtDecoderProviderConfigurationUtils() {
    }
}

