/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.data.redis.connection.RedisClusterCommands;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.RedisServerCommands;
import org.springframework.data.redis.core.AbstractOperations;
import org.springframework.data.redis.core.ClusterOperations;
import org.springframework.data.redis.core.RedisClusterCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class DefaultClusterOperations<K, V>
extends AbstractOperations<K, V>
implements ClusterOperations<K, V> {
    private final RedisTemplate<K, V> template;

    DefaultClusterOperations(RedisTemplate<K, V> template) {
        super(template);
        this.template = template;
    }

    @Override
    public Set<K> keys(RedisClusterNode node, K pattern) {
        Assert.notNull((Object)node, (String)"ClusterNode must not be null.");
        return this.execute(connection -> this.deserializeKeys(connection.keys(node, this.rawKey(pattern))));
    }

    @Override
    public K randomKey(RedisClusterNode node) {
        Assert.notNull((Object)node, (String)"ClusterNode must not be null.");
        return (K)this.execute(connection -> this.deserializeKey(connection.randomKey(node)));
    }

    @Override
    public String ping(RedisClusterNode node) {
        Assert.notNull((Object)node, (String)"ClusterNode must not be null.");
        return this.execute(connection -> connection.ping(node));
    }

    @Override
    public void addSlots(RedisClusterNode node, int ... slots) {
        Assert.notNull((Object)node, (String)"ClusterNode must not be null.");
        this.execute(connection -> {
            connection.clusterAddSlots(node, slots);
            return null;
        });
    }

    @Override
    public void addSlots(RedisClusterNode node, RedisClusterNode.SlotRange range) {
        Assert.notNull((Object)node, (String)"ClusterNode must not be null.");
        Assert.notNull((Object)range, (String)"Range must not be null.");
        this.addSlots(node, range.getSlotsArray());
    }

    @Override
    public void bgReWriteAof(RedisClusterNode node) {
        Assert.notNull((Object)node, (String)"ClusterNode must not be null.");
        this.execute(connection -> {
            connection.bgReWriteAof(node);
            return null;
        });
    }

    @Override
    public void bgSave(RedisClusterNode node) {
        Assert.notNull((Object)node, (String)"ClusterNode must not be null.");
        this.execute(connection -> {
            connection.bgSave(node);
            return null;
        });
    }

    @Override
    public void meet(RedisClusterNode node) {
        Assert.notNull((Object)node, (String)"ClusterNode must not be null.");
        this.execute(connection -> {
            connection.clusterMeet(node);
            return null;
        });
    }

    @Override
    public void forget(RedisClusterNode node) {
        Assert.notNull((Object)node, (String)"ClusterNode must not be null.");
        this.execute(connection -> {
            connection.clusterForget(node);
            return null;
        });
    }

    @Override
    public void flushDb(RedisClusterNode node) {
        Assert.notNull((Object)node, (String)"ClusterNode must not be null.");
        this.execute(connection -> {
            connection.flushDb(node);
            return null;
        });
    }

    @Override
    public Collection<RedisClusterNode> getSlaves(RedisClusterNode node) {
        Assert.notNull((Object)node, (String)"ClusterNode must not be null.");
        return this.execute(connection -> connection.clusterGetSlaves(node));
    }

    @Override
    public void save(RedisClusterNode node) {
        Assert.notNull((Object)node, (String)"ClusterNode must not be null.");
        this.execute(connection -> {
            connection.save(node);
            return null;
        });
    }

    @Override
    public void shutdown(RedisClusterNode node) {
        Assert.notNull((Object)node, (String)"ClusterNode must not be null.");
        this.execute(connection -> {
            connection.shutdown(node);
            return null;
        });
    }

    @Override
    public void reshard(RedisClusterNode source, int slot, RedisClusterNode target) {
        Assert.notNull((Object)source, (String)"Source node must not be null.");
        Assert.notNull((Object)target, (String)"Target node must not be null.");
        this.execute(connection -> {
            connection.clusterSetSlot(target, slot, RedisClusterCommands.AddSlots.IMPORTING);
            connection.clusterSetSlot(source, slot, RedisClusterCommands.AddSlots.MIGRATING);
            List<byte[]> keys = connection.clusterGetKeysInSlot(slot, Integer.MAX_VALUE);
            for (byte[] key : keys) {
                connection.migrate(key, source, 0, RedisServerCommands.MigrateOption.COPY);
            }
            connection.clusterSetSlot(target, slot, RedisClusterCommands.AddSlots.NODE);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> T execute(RedisClusterCallback<T> callback) {
        Assert.notNull(callback, (String)"ClusterCallback must not be null!");
        try (RedisClusterConnection connection = this.template.getConnectionFactory().getClusterConnection();){
            T t = callback.doInRedis(connection);
            return t;
        }
    }
}

