/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.pubsub.RedisPubSubListener;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import io.lettuce.core.pubsub.api.sync.RedisPubSubCommands;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionProvider;
import org.springframework.data.redis.connection.lettuce.LettuceMessageListener;
import org.springframework.data.redis.connection.util.AbstractSubscription;

public class LettuceSubscription
extends AbstractSubscription {
    private final StatefulRedisPubSubConnection<byte[], byte[]> connection;
    private final LettuceMessageListener listener;
    private final LettuceConnectionProvider connectionProvider;
    private final RedisPubSubCommands<byte[], byte[]> pubsub;

    protected LettuceSubscription(MessageListener listener, StatefulRedisPubSubConnection<byte[], byte[]> pubsubConnection, LettuceConnectionProvider connectionProvider) {
        super(listener);
        this.connection = pubsubConnection;
        this.listener = new LettuceMessageListener(listener);
        this.connectionProvider = connectionProvider;
        this.pubsub = this.connection.sync();
        this.connection.addListener((RedisPubSubListener)this.listener);
    }

    protected StatefulRedisPubSubConnection<byte[], byte[]> getNativeConnection() {
        return this.connection;
    }

    @Override
    protected void doClose() {
        if (!this.getChannels().isEmpty()) {
            this.doUnsubscribe(true, new byte[][]{new byte[0]});
        }
        if (!this.getPatterns().isEmpty()) {
            this.doPUnsubscribe(true, new byte[][]{new byte[0]});
        }
        this.connection.removeListener((RedisPubSubListener)this.listener);
        this.connectionProvider.release((StatefulConnection<?, ?>)this.connection);
    }

    @Override
    protected void doPsubscribe(byte[] ... patterns) {
        this.pubsub.psubscribe((Object[])patterns);
    }

    @Override
    protected void doPUnsubscribe(boolean all, byte[] ... patterns) {
        this.pubsub.punsubscribe((Object[])patterns);
    }

    @Override
    protected void doSubscribe(byte[] ... channels) {
        this.pubsub.subscribe((Object[])channels);
    }

    @Override
    protected void doUnsubscribe(boolean all, byte[] ... channels) {
        this.pubsub.unsubscribe((Object[])channels);
    }
}

