/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.config;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apiguardian.api.API;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.data.neo4j.core.schema.Node;
import org.springframework.data.neo4j.core.schema.RelationshipProperties;
import org.springframework.data.neo4j.repository.ReactiveNeo4jRepository;
import org.springframework.data.neo4j.repository.config.StartupLogger;
import org.springframework.data.neo4j.repository.support.Neo4jEvaluationContextExtension;
import org.springframework.data.neo4j.repository.support.ReactiveNeo4jRepositoryFactoryBean;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.core.RepositoryMetadata;

@API(status=API.Status.INTERNAL, since="6.0")
public final class ReactiveNeo4jRepositoryConfigurationExtension
extends RepositoryConfigurationExtensionSupport {
    private static final String MODULE_PREFIX = "neo4j";
    public static final String DEFAULT_NEO4J_CLIENT_BEAN_NAME = "reactiveNeo4jClient";
    public static final String DEFAULT_NEO4J_TEMPLATE_BEAN_NAME = "reactiveNeo4jTemplate";
    public static final String DEFAULT_TRANSACTION_MANAGER_BEAN_NAME = "reactiveTransactionManager";
    static final String DEFAULT_MAPPING_CONTEXT_BEAN_NAME = "neo4jMappingContext";

    public ReactiveNeo4jRepositoryConfigurationExtension() {
        new StartupLogger(StartupLogger.Mode.REACTIVE).logStarting();
    }

    public String getRepositoryFactoryBeanClassName() {
        return ReactiveNeo4jRepositoryFactoryBean.class.getName();
    }

    protected String getModulePrefix() {
        return MODULE_PREFIX;
    }

    protected Collection<Class<? extends Annotation>> getIdentifyingAnnotations() {
        return Arrays.asList(Node.class, RelationshipProperties.class);
    }

    public void registerBeansForRoot(BeanDefinitionRegistry registry, RepositoryConfigurationSource configurationSource) {
        ReactiveNeo4jRepositoryConfigurationExtension.registerIfNotAlreadyRegistered(() -> BeanDefinitionBuilder.rootBeanDefinition(Neo4jEvaluationContextExtension.class).setRole(2).getBeanDefinition(), (BeanDefinitionRegistry)registry, (String)Neo4jEvaluationContextExtension.class.getName(), (Object)configurationSource.getSource());
    }

    protected Collection<Class<?>> getIdentifyingTypes() {
        return Collections.singleton(ReactiveNeo4jRepository.class);
    }

    protected boolean useRepositoryConfiguration(RepositoryMetadata metadata) {
        return metadata.isReactiveRepository();
    }

    public void postProcess(BeanDefinitionBuilder builder, RepositoryConfigurationSource source) {
        builder.addPropertyValue("transactionManager", (Object)source.getAttribute("transactionManagerRef").orElse(DEFAULT_TRANSACTION_MANAGER_BEAN_NAME));
        builder.addPropertyReference("neo4jOperations", source.getAttribute("neo4jTemplateRef").orElse(DEFAULT_NEO4J_TEMPLATE_BEAN_NAME));
        builder.addPropertyReference(DEFAULT_MAPPING_CONTEXT_BEAN_NAME, source.getAttribute("neo4jMappingContextRef").orElse(DEFAULT_MAPPING_CONTEXT_BEAN_NAME));
    }
}

