/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.logging.LogFactory;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Functions;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.renderer.Renderer;
import org.neo4j.driver.exceptions.NoSuchRecordException;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.summary.SummaryCounters;
import org.reactivestreams.Publisher;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.core.log.LogAccessor;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.callback.ReactiveEntityCallbacks;
import org.springframework.data.neo4j.core.DatabaseSelection;
import org.springframework.data.neo4j.core.DynamicLabels;
import org.springframework.data.neo4j.core.PreparedQuery;
import org.springframework.data.neo4j.core.ReactiveDatabaseSelectionProvider;
import org.springframework.data.neo4j.core.ReactiveNeo4jClient;
import org.springframework.data.neo4j.core.ReactiveNeo4jOperations;
import org.springframework.data.neo4j.core.mapping.Constants;
import org.springframework.data.neo4j.core.mapping.CreateRelationshipStatementHolder;
import org.springframework.data.neo4j.core.mapping.CypherGenerator;
import org.springframework.data.neo4j.core.mapping.MappingSupport;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.core.mapping.NestedRelationshipContext;
import org.springframework.data.neo4j.core.mapping.NestedRelationshipProcessingStateMachine;
import org.springframework.data.neo4j.core.mapping.NodeDescription;
import org.springframework.data.neo4j.core.mapping.RelationshipDescription;
import org.springframework.data.neo4j.core.mapping.callback.ReactiveEventSupport;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

@API(status=API.Status.STABLE, since="6.0")
public final class ReactiveNeo4jTemplate
implements ReactiveNeo4jOperations,
BeanFactoryAware {
    private static final LogAccessor log = new LogAccessor(LogFactory.getLog(ReactiveNeo4jTemplate.class));
    private static final String OPTIMISTIC_LOCKING_ERROR_MESSAGE = "An entity with the required version does not exist.";
    private static final Renderer renderer = Renderer.getDefaultRenderer();
    private final ReactiveNeo4jClient neo4jClient;
    private final Neo4jMappingContext neo4jMappingContext;
    private final CypherGenerator cypherGenerator;
    private ReactiveEventSupport eventSupport;
    private final ReactiveDatabaseSelectionProvider databaseSelectionProvider;

    public ReactiveNeo4jTemplate(ReactiveNeo4jClient neo4jClient, Neo4jMappingContext neo4jMappingContext, ReactiveDatabaseSelectionProvider databaseSelectionProvider) {
        Assert.notNull((Object)neo4jClient, (String)"The Neo4jClient is required");
        Assert.notNull((Object)neo4jMappingContext, (String)"The Neo4jMappingContext is required");
        Assert.notNull((Object)databaseSelectionProvider, (String)"The database selection provider is required");
        this.neo4jClient = neo4jClient;
        this.neo4jMappingContext = neo4jMappingContext;
        this.cypherGenerator = CypherGenerator.INSTANCE;
        this.eventSupport = ReactiveEventSupport.useExistingCallbacks(neo4jMappingContext, ReactiveEntityCallbacks.create());
        this.databaseSelectionProvider = databaseSelectionProvider;
    }

    @Override
    public Mono<Long> count(Class<?> domainType) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(domainType);
        Statement statement = this.cypherGenerator.prepareMatchOf(entityMetaData).returning(new Expression[]{Functions.count((Expression)Cypher.asterisk())}).build();
        return this.count(statement);
    }

    @Override
    public Mono<Long> count(Statement statement) {
        return this.count(statement, Collections.emptyMap());
    }

    @Override
    public Mono<Long> count(Statement statement, Map<String, Object> parameters) {
        return this.count(renderer.render(statement), parameters);
    }

    @Override
    public Mono<Long> count(String cypherQuery) {
        return this.count(cypherQuery, Collections.emptyMap());
    }

    @Override
    public Mono<Long> count(String cypherQuery, Map<String, Object> parameters) {
        PreparedQuery<Long> preparedQuery = PreparedQuery.queryFor(Long.class).withCypherQuery(cypherQuery).withParameters(parameters).build();
        return this.toExecutableQuery(preparedQuery).flatMap(ReactiveNeo4jOperations.ExecutableQuery::getSingleResult);
    }

    @Override
    public <T> Flux<T> findAll(Class<T> domainType) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(domainType);
        Statement statement = this.cypherGenerator.prepareMatchOf(entityMetaData).returning(new Expression[]{this.cypherGenerator.createReturnStatementForMatch(entityMetaData)}).build();
        return this.createExecutableQuery(domainType, statement).flatMapMany(ReactiveNeo4jOperations.ExecutableQuery::getResults);
    }

    @Override
    public <T> Flux<T> findAll(Statement statement, Class<T> domainType) {
        return this.createExecutableQuery(domainType, statement).flatMapMany(ReactiveNeo4jOperations.ExecutableQuery::getResults);
    }

    @Override
    public <T> Flux<T> findAll(Statement statement, Map<String, Object> parameters, Class<T> domainType) {
        return this.createExecutableQuery(domainType, statement, parameters).flatMapMany(ReactiveNeo4jOperations.ExecutableQuery::getResults);
    }

    @Override
    public <T> Mono<T> findOne(Statement statement, Map<String, Object> parameters, Class<T> domainType) {
        return this.createExecutableQuery(domainType, statement, parameters).flatMap(ReactiveNeo4jOperations.ExecutableQuery::getSingleResult);
    }

    @Override
    public <T> Flux<T> findAll(String cypherQuery, Class<T> domainType) {
        return this.createExecutableQuery(domainType, cypherQuery).flatMapMany(ReactiveNeo4jOperations.ExecutableQuery::getResults);
    }

    @Override
    public <T> Flux<T> findAll(String cypherQuery, Map<String, Object> parameters, Class<T> domainType) {
        return this.createExecutableQuery(domainType, cypherQuery, parameters).flatMapMany(ReactiveNeo4jOperations.ExecutableQuery::getResults);
    }

    @Override
    public <T> Mono<T> findOne(String cypherQuery, Map<String, Object> parameters, Class<T> domainType) {
        return this.createExecutableQuery(domainType, cypherQuery, parameters).flatMap(ReactiveNeo4jOperations.ExecutableQuery::getSingleResult);
    }

    @Override
    public <T> Mono<T> findById(Object id, Class<T> domainType) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(domainType);
        Statement statement = this.cypherGenerator.prepareMatchOf(entityMetaData, entityMetaData.getIdExpression().isEqualTo((Expression)Cypher.parameter((String)"__id__"))).returning(new Expression[]{this.cypherGenerator.createReturnStatementForMatch(entityMetaData)}).build();
        return this.createExecutableQuery(domainType, statement, Collections.singletonMap("__id__", this.convertIdValues((Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty(), id))).flatMap(ReactiveNeo4jOperations.ExecutableQuery::getSingleResult);
    }

    @Override
    public <T> Flux<T> findAllById(Iterable<?> ids, Class<T> domainType) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(domainType);
        Statement statement = this.cypherGenerator.prepareMatchOf(entityMetaData, entityMetaData.getIdExpression().in((Expression)Cypher.parameter((String)"__ids__"))).returning(new Expression[]{this.cypherGenerator.createReturnStatementForMatch(entityMetaData)}).build();
        return this.createExecutableQuery(domainType, statement, Collections.singletonMap("__ids__", this.convertIdValues((Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty(), ids))).flatMapMany(ReactiveNeo4jOperations.ExecutableQuery::getResults);
    }

    private Object convertIdValues(@Nullable Neo4jPersistentProperty idProperty, Object idValues) {
        return this.neo4jMappingContext.getConversionService().writeValue(idValues, (TypeInformation<?>)ClassTypeInformation.from(idValues.getClass()), idProperty == null ? null : idProperty.getOptionalWritingConverter());
    }

    @Override
    public <T> Mono<T> save(T instance) {
        return this.getDatabaseName().flatMap(databaseName -> this.saveImpl(instance, databaseName.getValue()));
    }

    private <T> Mono<T> saveImpl(T instance, @Nullable String inDatabase) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(instance.getClass());
        return Mono.just((Object)entityMetaData.isNew(instance)).flatMap(isNewEntity -> Mono.just((Object)instance).flatMap(this.eventSupport::maybeCallBeforeBind).flatMap(entity -> this.determineDynamicLabels(entity, entityMetaData, inDatabase)).flatMap(t -> {
            Object entity = t.getT1();
            DynamicLabels dynamicLabels = (DynamicLabels)t.getT2();
            Statement saveStatement = this.cypherGenerator.prepareSaveOf(entityMetaData, dynamicLabels);
            Mono idMono = ((ReactiveNeo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(() -> renderer.render(saveStatement)).in(inDatabase).bind(entity).with(this.neo4jMappingContext.getRequiredBinderFunctionFor(entity.getClass()))).fetchAs(Long.class).one().switchIfEmpty(Mono.defer(() -> {
                if (entityMetaData.hasVersionProperty()) {
                    return Mono.error(() -> new OptimisticLockingFailureException(OPTIMISTIC_LOCKING_ERROR_MESSAGE));
                }
                return Mono.empty();
            }));
            if (!entityMetaData.isUsingInternalIds()) {
                return idMono.then(this.processRelations(entityMetaData, entity, (boolean)isNewEntity, inDatabase)).thenReturn(entity);
            }
            return idMono.map(internalId -> {
                PersistentPropertyAccessor propertyAccessor = entityMetaData.getPropertyAccessor(entity);
                propertyAccessor.setProperty(entityMetaData.getRequiredIdProperty(), internalId);
                return propertyAccessor.getBean();
            }).flatMap(savedEntity -> this.processRelations(entityMetaData, savedEntity, (boolean)isNewEntity, inDatabase).thenReturn(savedEntity));
        }));
    }

    private <T> Mono<Tuple2<T, DynamicLabels>> determineDynamicLabels(T entityToBeSaved, Neo4jPersistentEntity<?> entityMetaData, @Nullable String inDatabase) {
        return entityMetaData.getDynamicLabelsProperty().map(p -> {
            PersistentPropertyAccessor propertyAccessor = entityMetaData.getPropertyAccessor(entityToBeSaved);
            ReactiveNeo4jClient.RunnableSpecTightToDatabase runnableQuery = (ReactiveNeo4jClient.RunnableSpecTightToDatabase)((ReactiveNeo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(() -> renderer.render(this.cypherGenerator.createStatementReturningDynamicLabels(entityMetaData))).in(inDatabase).bind(propertyAccessor.getProperty(entityMetaData.getRequiredIdProperty())).to("__id__")).bind(entityMetaData.getStaticLabels()).to("__staticLabels__");
            if (entityMetaData.hasVersionProperty()) {
                runnableQuery = (ReactiveNeo4jClient.RunnableSpecTightToDatabase)runnableQuery.bind((Long)propertyAccessor.getProperty(entityMetaData.getRequiredVersionProperty()) - 1L).to("__version__");
            }
            return runnableQuery.fetch().one().map(m -> (Collection)m.get("__nodeLabels__")).switchIfEmpty(Mono.just(Collections.emptyList())).zipWith(Mono.just((Object)((Collection)propertyAccessor.getProperty((PersistentProperty)p)))).map(t -> Tuples.of((Object)entityToBeSaved, (Object)new DynamicLabels((Collection)t.getT1(), (Collection)t.getT2())));
        }).orElse(Mono.just((Object)Tuples.of(entityToBeSaved, (Object)DynamicLabels.EMPTY)));
    }

    @Override
    public <T> Flux<T> saveAll(Iterable<T> instances) {
        ArrayList entities;
        if (instances instanceof Collection) {
            entities = (ArrayList)instances;
        } else {
            entities = new ArrayList();
            instances.forEach(entities::add);
        }
        if (entities.isEmpty()) {
            return Flux.empty();
        }
        Class domainClass = CollectionUtils.findCommonElementType(entities);
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(domainClass);
        if (entityMetaData.isUsingInternalIds() || entityMetaData.hasVersionProperty()) {
            log.debug((CharSequence)"Saving entities using single statements.");
            return this.getDatabaseName().flatMapMany(databaseName -> Flux.fromIterable((Iterable)entities).flatMap(e -> this.saveImpl(e, databaseName.getValue())));
        }
        Function binderFunction = this.neo4jMappingContext.getRequiredBinderFunctionFor(domainClass);
        String isNewIndicatorKey = "isNewIndicator";
        return this.getDatabaseName().flatMapMany(databaseName -> Flux.fromIterable((Iterable)entities).flatMap(this.eventSupport::maybeCallBeforeBind).collectList().flatMapMany(entitiesToBeSaved -> Mono.defer(() -> {
            List boundedEntityList = entitiesToBeSaved.stream().map(binderFunction).collect(Collectors.toList());
            return ((ReactiveNeo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(() -> renderer.render(this.cypherGenerator.prepareSaveOfMultipleInstancesOf(entityMetaData))).in(databaseName.getValue()).bind(boundedEntityList).to("__entities__")).run();
        }).doOnNext(resultSummary -> {
            SummaryCounters counters = resultSummary.counters();
            log.debug(() -> String.format("Created %d and deleted %d nodes, created %d and deleted %d relationships and set %d properties.", counters.nodesCreated(), counters.nodesDeleted(), counters.relationshipsCreated(), counters.relationshipsDeleted(), counters.propertiesSet()));
        }).thenMany((Publisher)Flux.deferContextual(ctx -> {
            List isNewIndicator = (List)ctx.get((Object)isNewIndicatorKey);
            return Flux.fromIterable((Iterable)entitiesToBeSaved).index().flatMap(t -> {
                Object entityToBeSaved = t.getT2();
                boolean isNew = (Boolean)isNewIndicator.get(Math.toIntExact((Long)t.getT1()));
                return this.processRelations(entityMetaData, entityToBeSaved, isNew, databaseName.getValue()).then(Mono.just((Object)entityToBeSaved));
            });
        })))).contextWrite(ctx -> ctx.put((Object)isNewIndicatorKey, entities.stream().map(entity -> entityMetaData.isNew(entity)).collect(Collectors.toList())));
    }

    @Override
    public <T> Mono<Void> deleteAllById(Iterable<?> ids, Class<T> domainType) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(domainType);
        String nameOfParameter = "ids";
        Condition condition = entityMetaData.getIdExpression().in((Expression)Cypher.parameter((String)nameOfParameter));
        Statement statement = this.cypherGenerator.prepareDeleteOf(entityMetaData, condition);
        return this.getDatabaseName().flatMap(databaseName -> ((ReactiveNeo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(() -> renderer.render(statement)).in(databaseName.getValue()).bind(this.convertIdValues((Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty(), ids)).to(nameOfParameter)).run().then());
    }

    @Override
    public <T> Mono<Void> deleteById(Object id, Class<T> domainType) {
        Assert.notNull((Object)id, (String)"The given id must not be null!");
        String nameOfParameter = "id";
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(domainType);
        Condition condition = entityMetaData.getIdExpression().isEqualTo((Expression)Cypher.parameter((String)nameOfParameter));
        Statement statement = this.cypherGenerator.prepareDeleteOf(entityMetaData, condition);
        return this.getDatabaseName().flatMap(databaseName -> ((ReactiveNeo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(() -> renderer.render(statement)).in(databaseName.getValue()).bind(this.convertIdValues((Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty(), id)).to(nameOfParameter)).run().then());
    }

    @Override
    public <T> Mono<Void> deleteByIdWithVersion(Object id, Class<T> domainType, Neo4jPersistentProperty versionProperty, Object versionValue) {
        String nameOfParameter = "id";
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(domainType);
        Condition condition = entityMetaData.getIdExpression().isEqualTo((Expression)Cypher.parameter((String)nameOfParameter)).and(Cypher.property((Expression)Constants.NAME_OF_ROOT_NODE, (String)versionProperty.getPropertyName()).isEqualTo((Expression)Cypher.parameter((String)"__version__")).or(Cypher.property((Expression)Constants.NAME_OF_ROOT_NODE, (String)versionProperty.getPropertyName()).isNull()));
        Statement statement = this.cypherGenerator.prepareMatchOf(entityMetaData, condition).returning(new Expression[]{Constants.NAME_OF_ROOT_NODE}).build();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(nameOfParameter, this.convertIdValues((Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty(), id));
        parameters.put("__version__", versionValue);
        return this.getDatabaseName().flatMap(databaseName -> ((ReactiveNeo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(() -> renderer.render(statement)).in(databaseName.getValue()).bindAll(parameters)).fetch().one().switchIfEmpty(Mono.defer(() -> {
            if (entityMetaData.hasVersionProperty()) {
                return Mono.error(() -> new OptimisticLockingFailureException(OPTIMISTIC_LOCKING_ERROR_MESSAGE));
            }
            return Mono.empty();
        }))).then(this.deleteById(id, domainType));
    }

    @Override
    public Mono<Void> deleteAll(Class<?> domainType) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(domainType);
        Statement statement = this.cypherGenerator.prepareDeleteOf(entityMetaData);
        return this.getDatabaseName().flatMap(databaseName -> this.neo4jClient.query(() -> renderer.render(statement)).in(databaseName.getValue()).run().then());
    }

    private <T> Mono<ReactiveNeo4jOperations.ExecutableQuery<T>> createExecutableQuery(Class<T> domainType, Statement statement) {
        return this.createExecutableQuery(domainType, statement, Collections.emptyMap());
    }

    private <T> Mono<ReactiveNeo4jOperations.ExecutableQuery<T>> createExecutableQuery(Class<T> domainType, String cypherQuery) {
        return this.createExecutableQuery(domainType, cypherQuery, Collections.emptyMap());
    }

    private <T> Mono<ReactiveNeo4jOperations.ExecutableQuery<T>> createExecutableQuery(Class<T> domainType, Statement statement, Map<String, Object> parameters) {
        return this.createExecutableQuery(domainType, renderer.render(statement), parameters);
    }

    private <T> Mono<ReactiveNeo4jOperations.ExecutableQuery<T>> createExecutableQuery(Class<T> domainType, String cypherQuery, Map<String, Object> parameters) {
        Assert.notNull((Object)this.neo4jMappingContext.getPersistentEntity(domainType), (String)"Cannot get or create persistent entity.");
        PreparedQuery<T> preparedQuery = PreparedQuery.queryFor(domainType).withCypherQuery(cypherQuery).withParameters(parameters).usingMappingFunction(this.neo4jMappingContext.getRequiredMappingFunctionFor(domainType)).build();
        return this.toExecutableQuery(preparedQuery);
    }

    private Mono<Void> processRelations(Neo4jPersistentEntity<?> neo4jPersistentEntity, Object parentObject, boolean isParentObjectNew, @Nullable String inDatabase) {
        return this.processNestedRelations(neo4jPersistentEntity, parentObject, isParentObjectNew, inDatabase, new NestedRelationshipProcessingStateMachine());
    }

    private Mono<Void> processNestedRelations(Neo4jPersistentEntity<?> neo4jPersistentEntity, Object parentObject, boolean isParentObjectNew, @Nullable String inDatabase, NestedRelationshipProcessingStateMachine stateMachine) {
        return Mono.defer(() -> {
            PersistentPropertyAccessor propertyAccessor = neo4jPersistentEntity.getPropertyAccessor(parentObject);
            Object fromId = propertyAccessor.getProperty(neo4jPersistentEntity.getRequiredIdProperty());
            ArrayList relationshipCreationMonos = new ArrayList();
            neo4jPersistentEntity.doWithAssociations(association -> {
                NestedRelationshipContext relationshipContext = NestedRelationshipContext.of((Association<Neo4jPersistentProperty>)association, propertyAccessor, neo4jPersistentEntity);
                Collection<?> relatedValuesToStore = MappingSupport.unifyRelationshipValue(relationshipContext.getInverse(), relationshipContext.getValue());
                RelationshipDescription relationshipDescription = relationshipContext.getRelationship();
                RelationshipDescription relationshipDescriptionObverse = relationshipDescription.getRelationshipObverse();
                NestedRelationshipProcessingStateMachine.ProcessState processState = stateMachine.getStateOf(relationshipDescriptionObverse, relatedValuesToStore);
                if (processState == NestedRelationshipProcessingStateMachine.ProcessState.PROCESSED_ALL_RELATIONSHIPS) {
                    return;
                }
                if (!isParentObjectNew) {
                    Statement relationshipRemoveQuery = this.cypherGenerator.prepareDeleteOf(neo4jPersistentEntity, relationshipDescription);
                    relationshipCreationMonos.add(((ReactiveNeo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(renderer.render(relationshipRemoveQuery)).in(inDatabase).bind(this.convertIdValues((Neo4jPersistentProperty)neo4jPersistentEntity.getIdProperty(), fromId)).to("fromId")).run().checkpoint("delete relationships").then());
                }
                if (relationshipContext.inverseValueIsEmpty()) {
                    return;
                }
                stateMachine.markAsProcessed(relationshipDescription, relatedValuesToStore);
                for (Object relatedValueToStore : relatedValuesToStore) {
                    Object valueToBeSavedPreEvt = relationshipContext.identifyAndExtractRelationshipTargetNode(relatedValueToStore);
                    Mono createRelationship = this.eventSupport.maybeCallBeforeBind(valueToBeSavedPreEvt).flatMap(valueToBeSaved -> {
                        Neo4jPersistentEntity targetNodeDescription = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(valueToBeSavedPreEvt.getClass());
                        return Mono.just((Object)targetNodeDescription.isNew(valueToBeSaved)).flatMap(isNew -> this.saveRelatedNode(valueToBeSaved, relationshipContext.getAssociationTargetType(), targetNodeDescription, inDatabase).flatMap(relatedInternalId -> {
                            if (targetNodeDescription.isUsingInternalIds()) {
                                PersistentPropertyAccessor targetPropertyAccessor = targetNodeDescription.getPropertyAccessor(valueToBeSaved);
                                targetPropertyAccessor.setProperty(targetNodeDescription.getRequiredIdProperty(), relatedInternalId);
                            }
                            CreateRelationshipStatementHolder statementHolder = this.neo4jMappingContext.createStatement(neo4jPersistentEntity, relationshipContext, (Long)relatedInternalId, relatedValueToStore);
                            Mono<ResultSummary> relationshipCreationMonoNested = ((ReactiveNeo4jClient.RunnableSpecTightToDatabase)((ReactiveNeo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(renderer.render(statementHolder.getStatement())).in(inDatabase).bind(this.convertIdValues((Neo4jPersistentProperty)targetNodeDescription.getRequiredIdProperty(), fromId)).to("fromId")).bindAll(statementHolder.getProperties())).run();
                            if (processState != NestedRelationshipProcessingStateMachine.ProcessState.PROCESSED_ALL_VALUES) {
                                return relationshipCreationMonoNested.checkpoint().then(this.processNestedRelations(targetNodeDescription, valueToBeSaved, (boolean)isNew, inDatabase, stateMachine));
                            }
                            return relationshipCreationMonoNested.checkpoint().then();
                        }).checkpoint());
                    });
                    relationshipCreationMonos.add(createRelationship);
                }
            });
            return Flux.concat(relationshipCreationMonos).checkpoint().then();
        });
    }

    private <Y> Mono<Long> saveRelatedNode(Object relatedNode, Class<Y> entityType, NodeDescription targetNodeDescription, @Nullable String inDatabase) {
        return this.determineDynamicLabels(relatedNode, (Neo4jPersistentEntity)targetNodeDescription, inDatabase).flatMap(t -> {
            Object entity = t.getT1();
            DynamicLabels dynamicLabels = (DynamicLabels)t.getT2();
            return ((ReactiveNeo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(() -> renderer.render(this.cypherGenerator.prepareSaveOf(targetNodeDescription, dynamicLabels))).in(inDatabase).bind(entity).with(this.neo4jMappingContext.getRequiredBinderFunctionFor(entityType))).fetchAs(Long.class).one();
        }).switchIfEmpty(Mono.defer(() -> {
            if (((Neo4jPersistentEntity)targetNodeDescription).hasVersionProperty()) {
                return Mono.error(() -> new OptimisticLockingFailureException(OPTIMISTIC_LOCKING_ERROR_MESSAGE));
            }
            return Mono.empty();
        }));
    }

    private Mono<DatabaseSelection> getDatabaseName() {
        return this.databaseSelectionProvider.getDatabaseSelection().switchIfEmpty(Mono.just((Object)DatabaseSelection.undecided()));
    }

    @Override
    public <T> Mono<ReactiveNeo4jOperations.ExecutableQuery<T>> toExecutableQuery(PreparedQuery<T> preparedQuery) {
        return this.getDatabaseName().map(databaseName -> {
            Class resultType = preparedQuery.getResultType();
            ReactiveNeo4jClient.MappingSpec mappingSpec = ((ReactiveNeo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(preparedQuery.getCypherQuery()).in(databaseName.getValue()).bindAll(preparedQuery.getParameters())).fetchAs(resultType);
            ReactiveNeo4jClient.RecordFetchSpec fetchSpec = preparedQuery.getOptionalMappingFunction().map(mappingFunction -> mappingSpec.mappedBy(mappingFunction)).orElse(mappingSpec);
            return new DefaultReactiveExecutableQuery(preparedQuery, fetchSpec);
        });
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.eventSupport = ReactiveEventSupport.discoverCallbacks(this.neo4jMappingContext, beanFactory);
    }

    final class DefaultReactiveExecutableQuery<T>
    implements ReactiveNeo4jOperations.ExecutableQuery<T> {
        private final PreparedQuery<T> preparedQuery;
        private final ReactiveNeo4jClient.RecordFetchSpec<T> fetchSpec;

        DefaultReactiveExecutableQuery(PreparedQuery<T> preparedQuery, ReactiveNeo4jClient.RecordFetchSpec<T> fetchSpec) {
            this.preparedQuery = preparedQuery;
            this.fetchSpec = fetchSpec;
        }

        @Override
        public Flux<T> getResults() {
            return this.fetchSpec.all().switchOnFirst((signal, f) -> {
                if (this.preparedQuery.resultsHaveBeenAggregated()) {
                    return f.flatMap(nested -> Flux.fromIterable((Iterable)((Collection)nested)).distinct());
                }
                return f;
            });
        }

        @Override
        public Mono<T> getSingleResult() {
            try {
                return this.fetchSpec.one();
            }
            catch (NoSuchRecordException e) {
                throw new IncorrectResultSizeDataAccessException(e.getMessage(), 1);
            }
        }
    }
}

