/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.util.Collection;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.driver.Record;
import org.neo4j.driver.types.TypeSystem;
import org.springframework.data.neo4j.core.KRecordFetchSpec;
import org.springframework.data.neo4j.core.Neo4jClient;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007J\u000b\u0010\b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\tJ&\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00028\u00000\rJ\r\u0010\u0010\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\tR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/springframework/data/neo4j/core/KMappingSpec;", "T", "", "delegate", "Lorg/springframework/data/neo4j/core/Neo4jClient$MappingSpec;", "(Lorg/springframework/data/neo4j/core/Neo4jClient$MappingSpec;)V", "all", "", "first", "()Ljava/lang/Object;", "mappedBy", "Lorg/springframework/data/neo4j/core/KRecordFetchSpec;", "mappingFunction", "Ljava/util/function/BiFunction;", "Lorg/neo4j/driver/types/TypeSystem;", "Lorg/neo4j/driver/Record;", "one", "spring-data-neo4j"})
public final class KMappingSpec<T> {
    private final Neo4jClient.MappingSpec<T> delegate;

    @NotNull
    public final KRecordFetchSpec<T> mappedBy(@NotNull BiFunction<TypeSystem, Record, T> mappingFunction) {
        Intrinsics.checkNotNullParameter(mappingFunction, (String)"mappingFunction");
        Neo4jClient.RecordFetchSpec<T> recordFetchSpec = this.delegate.mappedBy(mappingFunction);
        Intrinsics.checkNotNullExpressionValue(recordFetchSpec, (String)"delegate.mappedBy(mappingFunction)");
        return new KRecordFetchSpec<T>(recordFetchSpec);
    }

    @Nullable
    public final T one() {
        return this.delegate.one().orElse(null);
    }

    @NotNull
    public final T first() {
        T t = this.delegate.first().orElse(null);
        Intrinsics.checkNotNullExpressionValue(t, (String)"delegate.first().orElse(null)");
        return t;
    }

    @NotNull
    public final Collection<T> all() {
        Collection collection = this.delegate.all();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"delegate.all()");
        return collection;
    }

    public KMappingSpec(@NotNull Neo4jClient.MappingSpec<T> delegate) {
        Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
        this.delegate = delegate;
    }
}

