/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.hbase;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.hadoop.configuration.ConfigurationUtils;
import org.springframework.util.StringUtils;

public class HbaseConfigurationFactoryBean
implements InitializingBean,
DisposableBean,
FactoryBean<Configuration> {
    private static final Log log = LogFactory.getLog(HbaseConfigurationFactoryBean.class);
    private boolean deleteConnection = true;
    private Configuration configuration;
    private Configuration hadoopConfig;
    private Properties properties;
    private String quorum;
    private Integer port;

    public void setDeleteConnection(boolean deleteConnection) {
        this.deleteConnection = deleteConnection;
    }

    public void setStopProxy(boolean stopProxy) {
        log.warn((Object)"Use of 'stopProxy' has been deprecated");
    }

    public void setConfiguration(Configuration configuration) {
        this.hadoopConfig = configuration;
    }

    public void destroy() {
        if (this.deleteConnection) {
            HConnectionManager.deleteConnection((Configuration)this.getObject());
        }
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void afterPropertiesSet() {
        this.configuration = this.hadoopConfig != null ? HBaseConfiguration.create((Configuration)this.hadoopConfig) : HBaseConfiguration.create();
        ConfigurationUtils.addProperties((Configuration)this.configuration, (Properties)this.properties);
        if (StringUtils.hasText((String)this.quorum)) {
            this.configuration.set("hbase.zookeeper.quorum", this.quorum.trim());
        }
        if (this.port != null) {
            this.configuration.set("hbase.zookeeper.property.clientPort", this.port.toString());
        }
    }

    public Configuration getObject() {
        return this.configuration;
    }

    public Class<? extends Configuration> getObjectType() {
        return this.configuration != null ? this.configuration.getClass() : Configuration.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setZkQuorum(String quorum) {
        this.quorum = quorum;
    }

    public void setZkPort(Integer port) {
        this.port = port;
    }
}

