/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import java.util.List;
import java.util.Map;
import org.springframework.data.elasticsearch.core.RefreshPolicy;
import org.springframework.data.elasticsearch.core.ScriptType;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.lang.Nullable;

public class UpdateQuery {
    private final String id;
    @Nullable
    private final String script;
    @Nullable
    private final Map<String, Object> params;
    @Nullable
    private final Document document;
    @Nullable
    private final Document upsert;
    @Nullable
    private final String lang;
    @Nullable
    private final String routing;
    @Nullable
    private final Boolean scriptedUpsert;
    @Nullable
    private final Boolean docAsUpsert;
    @Nullable
    private final Boolean fetchSource;
    @Nullable
    private final List<String> fetchSourceIncludes;
    @Nullable
    private final List<String> fetchSourceExcludes;
    @Nullable
    private final Integer ifSeqNo;
    @Nullable
    private final Integer ifPrimaryTerm;
    @Nullable
    private final RefreshPolicy refreshPolicy;
    @Nullable
    private final Integer retryOnConflict;
    @Nullable
    private final String timeout;
    @Nullable
    private final String waitForActiveShards;
    @Nullable
    private final Query query;
    @Nullable
    private final Boolean abortOnVersionConflict;
    @Nullable
    private final Integer batchSize;
    @Nullable
    private final Integer maxDocs;
    @Nullable
    private final Integer maxRetries;
    @Nullable
    private final String pipeline;
    @Nullable
    private final Float requestsPerSecond;
    @Nullable
    private final Boolean shouldStoreResult;
    @Nullable
    private final Integer slices;
    @Nullable
    private final ScriptType scriptType;
    @Nullable
    private final String scriptName;

    public static Builder builder(String id) {
        return new Builder(id);
    }

    public static Builder builder(Query query) {
        return new Builder(query);
    }

    private UpdateQuery(String id, @Nullable String script, @Nullable Map<String, Object> params, @Nullable Document document, @Nullable Document upsert, @Nullable String lang, @Nullable String routing, @Nullable Boolean scriptedUpsert, @Nullable Boolean docAsUpsert, @Nullable Boolean fetchSource, @Nullable List<String> fetchSourceIncludes, @Nullable List<String> fetchSourceExcludes, @Nullable Integer ifSeqNo, @Nullable Integer ifPrimaryTerm, @Nullable RefreshPolicy refreshPolicy, @Nullable Integer retryOnConflict, @Nullable String timeout, @Nullable String waitForActiveShards, @Nullable Query query, @Nullable Boolean abortOnVersionConflict, @Nullable Integer batchSize, @Nullable Integer maxDocs, @Nullable Integer maxRetries, @Nullable String pipeline, @Nullable Float requestsPerSecond, @Nullable Boolean shouldStoreResult, @Nullable Integer slices, @Nullable ScriptType scriptType, @Nullable String scriptName) {
        this.id = id;
        this.script = script;
        this.params = params;
        this.document = document;
        this.upsert = upsert;
        this.lang = lang;
        this.routing = routing;
        this.scriptedUpsert = scriptedUpsert;
        this.docAsUpsert = docAsUpsert;
        this.fetchSource = fetchSource;
        this.fetchSourceIncludes = fetchSourceIncludes;
        this.fetchSourceExcludes = fetchSourceExcludes;
        this.ifSeqNo = ifSeqNo;
        this.ifPrimaryTerm = ifPrimaryTerm;
        this.refreshPolicy = refreshPolicy;
        this.retryOnConflict = retryOnConflict;
        this.timeout = timeout;
        this.waitForActiveShards = waitForActiveShards;
        this.query = query;
        this.abortOnVersionConflict = abortOnVersionConflict;
        this.batchSize = batchSize;
        this.maxDocs = maxDocs;
        this.maxRetries = maxRetries;
        this.pipeline = pipeline;
        this.requestsPerSecond = requestsPerSecond;
        this.shouldStoreResult = shouldStoreResult;
        this.slices = slices;
        this.scriptType = scriptType;
        this.scriptName = scriptName;
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getScript() {
        return this.script;
    }

    @Nullable
    public Map<String, Object> getParams() {
        return this.params;
    }

    @Nullable
    public Document getDocument() {
        return this.document;
    }

    @Nullable
    public Document getUpsert() {
        return this.upsert;
    }

    @Nullable
    public String getLang() {
        return this.lang;
    }

    @Nullable
    public String getRouting() {
        return this.routing;
    }

    @Nullable
    public Boolean getScriptedUpsert() {
        return this.scriptedUpsert;
    }

    @Nullable
    public Boolean getDocAsUpsert() {
        return this.docAsUpsert;
    }

    @Nullable
    public Boolean getFetchSource() {
        return this.fetchSource;
    }

    @Nullable
    public List<String> getFetchSourceIncludes() {
        return this.fetchSourceIncludes;
    }

    @Nullable
    public List<String> getFetchSourceExcludes() {
        return this.fetchSourceExcludes;
    }

    @Nullable
    public Integer getIfSeqNo() {
        return this.ifSeqNo;
    }

    @Nullable
    public Integer getIfPrimaryTerm() {
        return this.ifPrimaryTerm;
    }

    @Nullable
    public RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    @Nullable
    public Integer getRetryOnConflict() {
        return this.retryOnConflict;
    }

    @Nullable
    public String getTimeout() {
        return this.timeout;
    }

    @Nullable
    public String getWaitForActiveShards() {
        return this.waitForActiveShards;
    }

    @Nullable
    public Query getQuery() {
        return this.query;
    }

    @Nullable
    public Boolean getAbortOnVersionConflict() {
        return this.abortOnVersionConflict;
    }

    @Nullable
    public Integer getBatchSize() {
        return this.batchSize;
    }

    @Nullable
    public Integer getMaxDocs() {
        return this.maxDocs;
    }

    @Nullable
    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    @Nullable
    public String getPipeline() {
        return this.pipeline;
    }

    @Nullable
    public Float getRequestsPerSecond() {
        return this.requestsPerSecond;
    }

    @Nullable
    public Boolean getShouldStoreResult() {
        return this.shouldStoreResult;
    }

    @Nullable
    public Integer getSlices() {
        return this.slices;
    }

    @Nullable
    public ScriptType getScriptType() {
        return this.scriptType;
    }

    @Nullable
    public String getScriptName() {
        return this.scriptName;
    }

    public static final class Builder {
        private String id;
        @Nullable
        private String script = null;
        @Nullable
        private Map<String, Object> params;
        @Nullable
        private Document document = null;
        @Nullable
        private Document upsert = null;
        @Nullable
        private String lang = "painless";
        @Nullable
        private String routing = null;
        @Nullable
        private Boolean scriptedUpsert;
        @Nullable
        private Boolean docAsUpsert;
        @Nullable
        private Boolean fetchSource;
        @Nullable
        private Integer ifSeqNo;
        @Nullable
        private Integer ifPrimaryTerm;
        @Nullable
        private RefreshPolicy refreshPolicy;
        @Nullable
        private Integer retryOnConflict;
        @Nullable
        private String timeout;
        @Nullable
        String waitForActiveShards;
        @Nullable
        private List<String> fetchSourceIncludes;
        @Nullable
        private List<String> fetchSourceExcludes;
        @Nullable
        private Query query;
        @Nullable
        private Boolean abortOnVersionConflict;
        @Nullable
        private Integer batchSize;
        @Nullable
        private Integer maxDocs;
        @Nullable
        private Integer maxRetries;
        @Nullable
        private String pipeline;
        @Nullable
        private Float requestsPerSecond;
        @Nullable
        private Boolean shouldStoreResult;
        @Nullable
        private Integer slices;
        @Nullable
        private ScriptType scriptType;
        @Nullable
        private String scriptName;

        private Builder(String id) {
            this.id = id;
        }

        private Builder(Query query) {
            this.query = query;
        }

        public Builder withScript(String script) {
            this.script = script;
            return this;
        }

        public Builder withParams(Map<String, Object> params) {
            this.params = params;
            return this;
        }

        public Builder withDocument(Document document) {
            this.document = document;
            return this;
        }

        public Builder withUpsert(Document upsert) {
            this.upsert = upsert;
            return this;
        }

        public Builder withLang(String lang) {
            this.lang = lang;
            return this;
        }

        public Builder withRouting(String routing) {
            this.routing = routing;
            return this;
        }

        public Builder withScriptedUpsert(Boolean scriptedUpsert) {
            this.scriptedUpsert = scriptedUpsert;
            return this;
        }

        public Builder withDocAsUpsert(Boolean docAsUpsert) {
            this.docAsUpsert = docAsUpsert;
            return this;
        }

        public Builder withFetchSource(Boolean fetchSource) {
            this.fetchSource = fetchSource;
            return this;
        }

        public Builder withIfSeqNo(Integer ifSeqNo) {
            this.ifSeqNo = ifSeqNo;
            return this;
        }

        public Builder withIfPrimaryTerm(Integer ifPrimaryTerm) {
            this.ifPrimaryTerm = ifPrimaryTerm;
            return this;
        }

        public Builder withRefreshPolicy(RefreshPolicy refreshPolicy) {
            this.refreshPolicy = refreshPolicy;
            return this;
        }

        public Builder withRetryOnConflict(Integer retryOnConflict) {
            this.retryOnConflict = retryOnConflict;
            return this;
        }

        public Builder withTimeout(String timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder withWaitForActiveShards(String waitForActiveShards) {
            this.waitForActiveShards = waitForActiveShards;
            return this;
        }

        public Builder withFetchSourceIncludes(List<String> fetchSourceIncludes) {
            this.fetchSourceIncludes = fetchSourceIncludes;
            return this;
        }

        public Builder withFetchSourceExcludes(List<String> fetchSourceExcludes) {
            this.fetchSourceExcludes = fetchSourceExcludes;
            return this;
        }

        public Builder withAbortOnVersionConflict(Boolean abortOnVersionConflict) {
            this.abortOnVersionConflict = abortOnVersionConflict;
            return this;
        }

        public Builder withBatchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder withMaxDocs(Integer maxDocs) {
            this.maxDocs = maxDocs;
            return this;
        }

        public Builder withMaxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder withPipeline(String pipeline) {
            this.pipeline = pipeline;
            return this;
        }

        public Builder withRequestsPerSecond(Float requestsPerSecond) {
            this.requestsPerSecond = requestsPerSecond;
            return this;
        }

        public Builder withShouldStoreResult(Boolean shouldStoreResult) {
            this.shouldStoreResult = shouldStoreResult;
            return this;
        }

        public Builder withSlices(Integer slices) {
            this.slices = slices;
            return this;
        }

        public Builder withScriptType(ScriptType scriptType) {
            this.scriptType = scriptType;
            return this;
        }

        public Builder withScriptName(String scriptName) {
            this.scriptName = scriptName;
            return this;
        }

        public UpdateQuery build() {
            if (this.script == null && this.document == null && this.query == null) {
                throw new IllegalArgumentException("either script, document or query must be set");
            }
            return new UpdateQuery(this.id, this.script, this.params, this.document, this.upsert, this.lang, this.routing, this.scriptedUpsert, this.docAsUpsert, this.fetchSource, this.fetchSourceIncludes, this.fetchSourceExcludes, this.ifSeqNo, this.ifPrimaryTerm, this.refreshPolicy, this.retryOnConflict, this.timeout, this.waitForActiveShards, this.query, this.abortOnVersionConflict, this.batchSize, this.maxDocs, this.maxRetries, this.pipeline, this.requestsPerSecond, this.shouldStoreResult, this.slices, this.scriptType, this.scriptName);
        }
    }
}

