/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alicloud.acm.refresh;

import com.alibaba.edas.acm.ConfigService;
import com.alibaba.edas.acm.listener.ConfigChangeListener;
import com.alibaba.edas.acm.listener.ConfigChangeListenerAdapter;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.cloud.alicloud.acm.AcmPropertySourceRepository;
import org.springframework.cloud.alicloud.acm.refresh.AcmRefreshHistory;
import org.springframework.cloud.alicloud.context.acm.AcmIntegrationProperties;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.cloud.endpoint.event.RefreshEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.util.StringUtils;

public class AcmContextRefresher
implements ApplicationListener<ApplicationReadyEvent>,
ApplicationContextAware {
    private Logger log = LoggerFactory.getLogger(AcmContextRefresher.class);
    private final ContextRefresher contextRefresher;
    private final AcmIntegrationProperties acmIntegrationProperties;
    private final AcmRefreshHistory refreshHistory;
    private ApplicationContext applicationContext;
    private final AcmPropertySourceRepository acmPropertySourceRepository;
    private Map<String, ConfigChangeListener> listenerMap = new ConcurrentHashMap<String, ConfigChangeListener>(16);

    public AcmContextRefresher(ContextRefresher contextRefresher, AcmIntegrationProperties acmIntegrationProperties, AcmRefreshHistory refreshHistory, AcmPropertySourceRepository acmPropertySourceRepository) {
        this.contextRefresher = contextRefresher;
        this.acmIntegrationProperties = acmIntegrationProperties;
        this.refreshHistory = refreshHistory;
        this.acmPropertySourceRepository = acmPropertySourceRepository;
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        this.registerDiamondListenersForApplications();
    }

    private void registerDiamondListenersForApplications() {
        if (this.acmIntegrationProperties.getAcmProperties().isRefreshEnabled()) {
            for (String dataId : this.acmIntegrationProperties.getApplicationConfigurationDataIds()) {
                this.registerDiamondListener(dataId);
            }
        }
    }

    private void registerDiamondListener(final String dataId) {
        ConfigChangeListener listener = this.listenerMap.computeIfAbsent(dataId, i -> new ConfigChangeListener(){

            public void receiveConfigInfo(String configInfo) {
                String md5 = "";
                if (!StringUtils.isEmpty((Object)configInfo)) {
                    try {
                        MessageDigest md = MessageDigest.getInstance("MD5");
                        md5 = new BigInteger(1, md.digest(configInfo.getBytes("UTF-8"))).toString(16);
                    }
                    catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
                        AcmContextRefresher.this.log.warn("unable to get md5 for dataId: " + dataId, (Throwable)e);
                    }
                }
                AcmContextRefresher.this.refreshHistory.add(dataId, md5);
                AcmContextRefresher.this.applicationContext.publishEvent((ApplicationEvent)new RefreshEvent((Object)this, (Object)md5, "ACM Refresh, dataId=" + dataId));
            }
        });
        ConfigService.addListener((String)dataId, (String)this.acmIntegrationProperties.getAcmProperties().getGroup(), (ConfigChangeListenerAdapter)listener);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

