/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alicloud.acm.endpoint;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.cloud.alicloud.acm.AcmPropertySourceRepository;
import org.springframework.cloud.alicloud.acm.endpoint.AcmEndpoint;
import org.springframework.cloud.alicloud.acm.endpoint.AcmHealthIndicator;
import org.springframework.cloud.alicloud.acm.refresh.AcmRefreshHistory;
import org.springframework.cloud.alicloud.context.acm.AcmProperties;
import org.springframework.context.annotation.Bean;

@ConditionalOnWebApplication
@ConditionalOnClass(name={"org.springframework.boot.actuate.autoconfigure.web.ManagementContextConfiguration"})
public class AcmEndpointAutoConfiguration {
    @Autowired
    private AcmProperties acmProperties;
    @Autowired
    private AcmRefreshHistory acmRefreshHistory;
    @Autowired
    private AcmPropertySourceRepository acmPropertySourceRepository;

    @ConditionalOnMissingBean
    @ConditionalOnEnabledEndpoint
    @Bean
    public AcmEndpoint acmEndpoint() {
        return new AcmEndpoint(this.acmProperties, this.acmRefreshHistory, this.acmPropertySourceRepository);
    }

    @Bean
    @ConditionalOnMissingBean
    public AcmHealthIndicator acmHealthIndicator(AcmProperties acmProperties, AcmPropertySourceRepository acmPropertySourceRepository) {
        return new AcmHealthIndicator(acmProperties, acmPropertySourceRepository);
    }
}

