/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alicloud.acm.endpoint;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.cloud.alicloud.acm.AcmPropertySourceRepository;
import org.springframework.cloud.alicloud.acm.bootstrap.AcmPropertySource;
import org.springframework.cloud.alicloud.acm.refresh.AcmRefreshHistory;
import org.springframework.cloud.alicloud.context.acm.AcmProperties;

@Endpoint(id="acm")
public class AcmEndpoint {
    private final AcmProperties properties;
    private final AcmRefreshHistory refreshHistory;
    private final AcmPropertySourceRepository propertySourceRepository;
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public AcmEndpoint(AcmProperties properties, AcmRefreshHistory refreshHistory, AcmPropertySourceRepository propertySourceRepository) {
        this.properties = properties;
        this.refreshHistory = refreshHistory;
        this.propertySourceRepository = propertySourceRepository;
    }

    @ReadOperation
    public Map<String, Object> invoke() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("config", this.properties);
        HashMap<String, AbstractList> runtime = new HashMap<String, AbstractList>();
        List<AcmPropertySource> all = this.propertySourceRepository.getAll();
        ArrayList sources = new ArrayList();
        for (AcmPropertySource ps : all) {
            HashMap<String, String> source = new HashMap<String, String>();
            source.put("dataId", ps.getDataId());
            source.put("lastSynced", this.dateFormat.format(ps.getTimestamp()));
            sources.add(source);
        }
        runtime.put("sources", sources);
        runtime.put("refreshHistory", this.refreshHistory.getRecords());
        result.put("runtime", runtime);
        return result;
    }
}

