/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alicloud.acm.bootstrap;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.alicloud.acm.bootstrap.AcmPropertySource;
import org.springframework.cloud.alicloud.acm.bootstrap.AcmPropertySourceBuilder;
import org.springframework.cloud.alicloud.context.acm.AcmIntegrationProperties;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;

public class AcmPropertySourceLocator
implements PropertySourceLocator {
    private static final String DIAMOND_PROPERTY_SOURCE_NAME = "diamond";
    private AcmPropertySourceBuilder acmPropertySourceBuilder = new AcmPropertySourceBuilder();
    @Autowired
    private AcmIntegrationProperties acmIntegrationProperties;

    public PropertySource<?> locate(Environment environment) {
        CompositePropertySource compositePropertySource = new CompositePropertySource(DIAMOND_PROPERTY_SOURCE_NAME);
        this.acmIntegrationProperties.setActiveProfiles(environment.getActiveProfiles());
        for (String dataId : this.acmIntegrationProperties.getGroupConfigurationDataIds()) {
            this.loadDiamondDataIfPresent(compositePropertySource, dataId, this.acmIntegrationProperties.getAcmProperties().getGroup(), true);
        }
        for (String dataId : this.acmIntegrationProperties.getApplicationConfigurationDataIds()) {
            this.loadDiamondDataIfPresent(compositePropertySource, dataId, this.acmIntegrationProperties.getAcmProperties().getGroup(), false);
        }
        return compositePropertySource;
    }

    private void loadDiamondDataIfPresent(CompositePropertySource composite, String dataId, String diamondGroup, boolean groupLevel) {
        AcmPropertySource ps = this.acmPropertySourceBuilder.build(dataId, diamondGroup, groupLevel);
        if (ps != null) {
            composite.addFirstPropertySource((PropertySource)ps);
        }
    }
}

