/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alicloud.acm.bootstrap;

import com.alibaba.edas.acm.ConfigService;
import com.alibaba.edas.acm.exception.ConfigException;
import java.io.StringReader;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.cloud.alicloud.acm.bootstrap.AcmPropertySource;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

class AcmPropertySourceBuilder {
    private Logger log = LoggerFactory.getLogger(AcmPropertySourceBuilder.class);

    AcmPropertySourceBuilder() {
    }

    AcmPropertySource build(String dataId, String diamondGroup, boolean groupLevel) {
        Properties properties = this.loadDiamondData(dataId, diamondGroup);
        if (properties == null) {
            return null;
        }
        return new AcmPropertySource(dataId, this.toMap(properties), new Date(), groupLevel);
    }

    private Properties loadDiamondData(String dataId, String diamondGroup) {
        try {
            String data = ConfigService.getConfig((String)dataId, (String)diamondGroup, (long)3000L);
            if (StringUtils.isEmpty((Object)data)) {
                return null;
            }
            if (dataId.endsWith(".properties")) {
                Properties properties = new Properties();
                this.log.info(String.format("Loading acm data, dataId: '%s', group: '%s'", dataId, diamondGroup));
                properties.load(new StringReader(data));
                return properties;
            }
            if (dataId.endsWith(".yaml") || dataId.endsWith(".yml")) {
                YamlPropertiesFactoryBean yamlFactory = new YamlPropertiesFactoryBean();
                yamlFactory.setResources(new Resource[]{new ByteArrayResource(data.getBytes())});
                return yamlFactory.getObject();
            }
        }
        catch (Exception e) {
            if (e instanceof ConfigException) {
                this.log.error("DIAMOND-100500:" + dataId + ", " + e.toString(), (Throwable)e);
            }
            this.log.error("DIAMOND-100500:" + dataId, (Throwable)e);
        }
        return null;
    }

    private Map<String, Object> toMap(Properties properties) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Enumeration<?> keys = properties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = properties.getProperty(key);
            if (value != null) {
                result.put(key, value.trim());
                continue;
            }
            result.put(key, null);
        }
        return result;
    }
}

