/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.ssl.pem;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.springframework.boot.ssl.SslStoreBundle;
import org.springframework.boot.ssl.pem.PemCertificateParser;
import org.springframework.boot.ssl.pem.PemContent;
import org.springframework.boot.ssl.pem.PemPrivateKeyParser;
import org.springframework.boot.ssl.pem.PemSslStoreDetails;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class PemSslStoreBundle
implements SslStoreBundle {
    private static final String DEFAULT_KEY_ALIAS = "ssl";
    private final KeyStore keyStore;
    private final KeyStore trustStore;

    public PemSslStoreBundle(PemSslStoreDetails keyStoreDetails, PemSslStoreDetails trustStoreDetails) {
        this(keyStoreDetails, trustStoreDetails, null);
    }

    public PemSslStoreBundle(PemSslStoreDetails keyStoreDetails, PemSslStoreDetails trustStoreDetails, String keyAlias) {
        this.keyStore = this.createKeyStore("key", keyStoreDetails, keyAlias);
        this.trustStore = this.createKeyStore("trust", trustStoreDetails, keyAlias);
    }

    @Override
    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    @Override
    public String getKeyStorePassword() {
        return null;
    }

    @Override
    public KeyStore getTrustStore() {
        return this.trustStore;
    }

    private KeyStore createKeyStore(String name, PemSslStoreDetails details, String alias) {
        if (details == null || details.isEmpty()) {
            return null;
        }
        try {
            Assert.notNull((Object)details.certificate(), (String)"Certificate content must not be null");
            String type = !StringUtils.hasText((String)details.type()) ? KeyStore.getDefaultType() : details.type();
            KeyStore store = KeyStore.getInstance(type);
            store.load(null);
            String certificateContent = PemContent.load(details.certificate());
            String privateKeyContent = PemContent.load(details.privateKey());
            X509Certificate[] certificates = PemCertificateParser.parse(certificateContent);
            PrivateKey privateKey = PemPrivateKeyParser.parse(privateKeyContent, details.privateKeyPassword());
            this.addCertificates(store, certificates, privateKey, alias != null ? alias : DEFAULT_KEY_ALIAS);
            return store;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to create %s store: %s".formatted(name, ex.getMessage()), ex);
        }
    }

    private void addCertificates(KeyStore keyStore, X509Certificate[] certificates, PrivateKey privateKey, String alias) throws KeyStoreException {
        if (privateKey != null) {
            keyStore.setKeyEntry(alias, privateKey, null, certificates);
        } else {
            for (int index = 0; index < certificates.length; ++index) {
                keyStore.setCertificateEntry(alias + "-" + index, certificates[index]);
            }
        }
    }
}

