/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.restart;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.springframework.boot.devtools.logger.DevToolsLogFactory;
import org.springframework.boot.devtools.settings.DevToolsSettings;
import org.springframework.util.StringUtils;

final class ChangeableUrls
implements Iterable<URL> {
    private static final Log logger = DevToolsLogFactory.getLog(ChangeableUrls.class);
    private final List<URL> urls;

    private ChangeableUrls(URL ... urls) {
        DevToolsSettings settings = DevToolsSettings.get();
        ArrayList<URL> reloadableUrls = new ArrayList<URL>(urls.length);
        for (URL url : urls) {
            if (!settings.isRestartInclude(url) && !this.isFolderUrl(url.toString()) || settings.isRestartExclude(url)) continue;
            reloadableUrls.add(url);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Matching URLs for reloading : " + reloadableUrls));
        }
        this.urls = Collections.unmodifiableList(reloadableUrls);
    }

    private boolean isFolderUrl(String urlString) {
        return urlString.startsWith("file:") && urlString.endsWith("/");
    }

    @Override
    public Iterator<URL> iterator() {
        return this.urls.iterator();
    }

    public int size() {
        return this.urls.size();
    }

    public URL[] toArray() {
        return this.urls.toArray(new URL[0]);
    }

    public List<URL> toList() {
        return Collections.unmodifiableList(this.urls);
    }

    public String toString() {
        return this.urls.toString();
    }

    public static ChangeableUrls fromClassLoader(ClassLoader classLoader) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (URL url : ChangeableUrls.urlsFromClassLoader(classLoader)) {
            urls.add(url);
            urls.addAll(ChangeableUrls.getUrlsFromClassPathOfJarManifestIfPossible(url));
        }
        return ChangeableUrls.fromUrls(urls);
    }

    private static URL[] urlsFromClassLoader(ClassLoader classLoader) {
        if (classLoader instanceof URLClassLoader) {
            return ((URLClassLoader)classLoader).getURLs();
        }
        return (URL[])Stream.of(ManagementFactory.getRuntimeMXBean().getClassPath().split(File.pathSeparator)).map(ChangeableUrls::toURL).toArray(URL[]::new);
    }

    private static URL toURL(String classPathEntry) {
        try {
            return new File(classPathEntry).toURI().toURL();
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("URL could not be created from '" + classPathEntry + "'", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<URL> getUrlsFromClassPathOfJarManifestIfPossible(URL url) {
        try {
            File file = new File(url.toURI());
            if (!file.isFile()) return Collections.emptyList();
            Throwable throwable = null;
            try (JarFile jarFile = new JarFile(file);){
                List<URL> list = ChangeableUrls.getUrlsFromManifestClassPathAttribute(url, jarFile);
                return list;
            }
            catch (IOException ex) {
                try {
                    throw new IllegalStateException("Failed to read Class-Path attribute from manifest of jar " + url, ex);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    private static List<URL> getUrlsFromManifestClassPathAttribute(URL jarUrl, JarFile jarFile) throws IOException {
        Manifest manifest = jarFile.getManifest();
        if (manifest == null) {
            return Collections.emptyList();
        }
        String classPath = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
        if (!StringUtils.hasText((String)classPath)) {
            return Collections.emptyList();
        }
        String[] entries = StringUtils.delimitedListToStringArray((String)classPath, (String)" ");
        ArrayList<URL> urls = new ArrayList<URL>(entries.length);
        ArrayList<URL> nonExistentEntries = new ArrayList<URL>();
        for (String entry : entries) {
            try {
                URL referenced = new URL(jarUrl, entry);
                if (new File(referenced.getFile()).exists()) {
                    urls.add(referenced);
                    continue;
                }
                nonExistentEntries.add(referenced);
            }
            catch (MalformedURLException ex) {
                throw new IllegalStateException("Class-Path attribute contains malformed URL", ex);
            }
        }
        if (!nonExistentEntries.isEmpty()) {
            System.out.println("The Class-Path manifest attribute in " + jarFile.getName() + " referenced one or more files that do not exist: " + StringUtils.collectionToCommaDelimitedString(nonExistentEntries));
        }
        return urls;
    }

    public static ChangeableUrls fromUrls(Collection<URL> urls) {
        return ChangeableUrls.fromUrls(new ArrayList<URL>(urls).toArray(new URL[urls.size()]));
    }

    public static ChangeableUrls fromUrls(URL ... urls) {
        return new ChangeableUrls(urls);
    }
}

