/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.http.codec;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.http.HttpProperties;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.codec.CodecCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.util.MimeType;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={CodecConfigurer.class, WebClient.class})
@AutoConfigureAfter(value={JacksonAutoConfiguration.class})
public class CodecsAutoConfiguration {
    private static final MimeType[] EMPTY_MIME_TYPES = new MimeType[0];

    @Configuration(proxyBeanMethods=false)
    @EnableConfigurationProperties(value={HttpProperties.class})
    static class LoggingCodecConfiguration {
        LoggingCodecConfiguration() {
        }

        @Bean
        @Order(value=0)
        CodecCustomizer loggingCodecCustomizer(HttpProperties properties) {
            return configurer -> configurer.defaultCodecs().enableLoggingRequestDetails(properties.isLogRequestDetails());
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ObjectMapper.class})
    static class JacksonCodecConfiguration {
        JacksonCodecConfiguration() {
        }

        @Bean
        @Order(value=0)
        @ConditionalOnBean(value={ObjectMapper.class})
        CodecCustomizer jacksonCodecCustomizer(ObjectMapper objectMapper) {
            return configurer -> {
                CodecConfigurer.DefaultCodecs defaults = configurer.defaultCodecs();
                defaults.jackson2JsonDecoder((Decoder)new Jackson2JsonDecoder(objectMapper, EMPTY_MIME_TYPES));
                defaults.jackson2JsonEncoder((Encoder)new Jackson2JsonEncoder(objectMapper, EMPTY_MIME_TYPES));
            };
        }
    }
}

