/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener;

import java.util.ArrayList;
import java.util.List;
import org.springframework.amqp.rabbit.listener.RabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpoint;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpointRegistry;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.lang.Nullable;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.util.Assert;

public class RabbitListenerEndpointRegistrar
implements BeanFactoryAware,
InitializingBean {
    private final List<AmqpListenerEndpointDescriptor> endpointDescriptors = new ArrayList<AmqpListenerEndpointDescriptor>();
    @Nullable
    private RabbitListenerEndpointRegistry endpointRegistry;
    private MessageHandlerMethodFactory messageHandlerMethodFactory;
    private RabbitListenerContainerFactory<?> containerFactory;
    private String containerFactoryBeanName;
    private BeanFactory beanFactory;
    private boolean startImmediately;

    public void setEndpointRegistry(RabbitListenerEndpointRegistry endpointRegistry) {
        this.endpointRegistry = endpointRegistry;
    }

    @Nullable
    public RabbitListenerEndpointRegistry getEndpointRegistry() {
        return this.endpointRegistry;
    }

    public void setMessageHandlerMethodFactory(MessageHandlerMethodFactory rabbitHandlerMethodFactory) {
        this.messageHandlerMethodFactory = rabbitHandlerMethodFactory;
    }

    public MessageHandlerMethodFactory getMessageHandlerMethodFactory() {
        return this.messageHandlerMethodFactory;
    }

    public void setContainerFactory(RabbitListenerContainerFactory<?> containerFactory) {
        this.containerFactory = containerFactory;
    }

    public void setContainerFactoryBeanName(String containerFactoryBeanName) {
        this.containerFactoryBeanName = containerFactoryBeanName;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() {
        this.registerAllEndpoints();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerAllEndpoints() {
        Assert.state((this.endpointRegistry != null ? 1 : 0) != 0, (String)"No registry available");
        List<AmqpListenerEndpointDescriptor> list = this.endpointDescriptors;
        synchronized (list) {
            for (AmqpListenerEndpointDescriptor descriptor : this.endpointDescriptors) {
                this.endpointRegistry.registerListenerContainer(descriptor.endpoint, this.resolveContainerFactory(descriptor));
            }
            this.startImmediately = true;
        }
    }

    private RabbitListenerContainerFactory<?> resolveContainerFactory(AmqpListenerEndpointDescriptor descriptor) {
        if (descriptor.containerFactory != null) {
            return descriptor.containerFactory;
        }
        if (this.containerFactory != null) {
            return this.containerFactory;
        }
        if (this.containerFactoryBeanName != null) {
            Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set to obtain container factory by bean name");
            this.containerFactory = (RabbitListenerContainerFactory)this.beanFactory.getBean(this.containerFactoryBeanName, RabbitListenerContainerFactory.class);
            return this.containerFactory;
        }
        throw new IllegalStateException("Could not resolve the " + RabbitListenerContainerFactory.class.getSimpleName() + " to use for [" + descriptor.endpoint + "] no factory was given and no default is set.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEndpoint(RabbitListenerEndpoint endpoint, @Nullable RabbitListenerContainerFactory<?> factory) {
        Assert.notNull((Object)endpoint, (String)"Endpoint must be set");
        Assert.hasText((String)endpoint.getId(), (String)"Endpoint id must be set");
        Assert.state((!this.startImmediately || this.endpointRegistry != null ? 1 : 0) != 0, (String)"No registry available");
        AmqpListenerEndpointDescriptor descriptor = new AmqpListenerEndpointDescriptor(endpoint, factory);
        List<AmqpListenerEndpointDescriptor> list = this.endpointDescriptors;
        synchronized (list) {
            if (this.startImmediately) {
                this.endpointRegistry.registerListenerContainer(descriptor.endpoint, this.resolveContainerFactory(descriptor), true);
            } else {
                this.endpointDescriptors.add(descriptor);
            }
        }
    }

    public void registerEndpoint(RabbitListenerEndpoint endpoint) {
        this.registerEndpoint(endpoint, null);
    }

    private static final class AmqpListenerEndpointDescriptor {
        private final RabbitListenerEndpoint endpoint;
        private final RabbitListenerContainerFactory<?> containerFactory;

        AmqpListenerEndpointDescriptor(RabbitListenerEndpoint endpoint, @Nullable RabbitListenerContainerFactory<?> containerFactory) {
            this.endpoint = endpoint;
            this.containerFactory = containerFactory;
        }
    }
}

