/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.rabbit.connection.AbstractConnectionFactory;
import org.springframework.amqp.rabbit.connection.ChannelProxy;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.RabbitUtils;
import org.springframework.amqp.rabbit.connection.SimpleConnection;
import org.springframework.amqp.rabbit.support.RabbitExceptionTranslator;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.NameMatchMethodPointcutAdvisor;

public class ThreadChannelConnectionFactory
extends AbstractConnectionFactory {
    private volatile ConnectionWrapper connection;
    private boolean simplePublisherConfirms;

    public ThreadChannelConnectionFactory(ConnectionFactory rabbitConnectionFactory) {
        this(rabbitConnectionFactory, false);
    }

    private ThreadChannelConnectionFactory(ConnectionFactory rabbitConnectionFactory, boolean isPublisher) {
        super(rabbitConnectionFactory);
        if (!isPublisher) {
            this.setPublisherConnectionFactory(new ThreadChannelConnectionFactory(rabbitConnectionFactory, true));
        }
    }

    @Override
    public boolean isSimplePublisherConfirms() {
        return this.simplePublisherConfirms;
    }

    public void setSimplePublisherConfirms(boolean simplePublisherConfirms) {
        this.simplePublisherConfirms = simplePublisherConfirms;
    }

    @Override
    public synchronized Connection createConnection() throws AmqpException {
        if (this.connection == null || !this.connection.isOpen()) {
            Connection bareConnection = this.createBareConnection();
            this.connection = new ConnectionWrapper(bareConnection.getDelegate(), this.getCloseTimeout());
        }
        return this.connection;
    }

    public void closeThreadChannel() {
        ConnectionWrapper connection2 = this.connection;
        if (connection2 != null) {
            connection2.closeThreadChannel();
        }
    }

    @Override
    public synchronized void destroy() {
        super.destroy();
        if (this.connection != null) {
            this.connection.forceClose();
            this.connection = null;
        }
    }

    private final class ConnectionWrapper
    extends SimpleConnection {
        private final ThreadLocal<Channel> channels;
        private final ThreadLocal<Channel> txChannels;

        ConnectionWrapper(com.rabbitmq.client.Connection delegate, int closeTimeout) {
            super(delegate, closeTimeout);
            this.channels = new ThreadLocal();
            this.txChannels = new ThreadLocal();
        }

        @Override
        public Channel createChannel(boolean transactional) {
            Channel channel;
            Channel channel2 = channel = transactional ? this.txChannels.get() : this.channels.get();
            if (channel == null || !channel.isOpen()) {
                channel = this.createProxy(super.createChannel(transactional), transactional);
                if (transactional) {
                    try {
                        channel.txSelect();
                    }
                    catch (IOException e) {
                        throw RabbitExceptionTranslator.convertRabbitAccessException(e);
                    }
                    this.txChannels.set(channel);
                } else {
                    if (ThreadChannelConnectionFactory.this.simplePublisherConfirms) {
                        try {
                            channel.confirmSelect();
                        }
                        catch (IOException e) {
                            throw RabbitExceptionTranslator.convertRabbitAccessException(e);
                        }
                    }
                    this.channels.set(channel);
                }
            }
            return channel;
        }

        private Channel createProxy(Channel channel, boolean transactional) {
            ProxyFactory pf = new ProxyFactory((Object)channel);
            AtomicBoolean confirmSelected = new AtomicBoolean();
            MethodInterceptor advice = invocation -> {
                String method;
                switch (method = invocation.getMethod().getName()) {
                    case "close": {
                        this.handleClose(channel, transactional);
                        return null;
                    }
                    case "getTargetChannel": {
                        return channel;
                    }
                    case "isTransactional": {
                        return transactional;
                    }
                    case "confirmSelect": {
                        confirmSelected.set(true);
                        return channel.confirmSelect();
                    }
                    case "isConfirmSelected": {
                        return confirmSelected.get();
                    }
                }
                return null;
            };
            NameMatchMethodPointcutAdvisor advisor = new NameMatchMethodPointcutAdvisor((Advice)advice);
            advisor.addMethodName("close");
            advisor.addMethodName("getTargetChannel");
            advisor.addMethodName("isTransactional");
            advisor.addMethodName("confirmSelect");
            advisor.addMethodName("isConfirmSelected");
            pf.addAdvisor((Advisor)advisor);
            pf.addInterface(ChannelProxy.class);
            return (Channel)pf.getProxy();
        }

        private void handleClose(Channel channel, boolean transactional) {
            if (this.channels.get() == null) {
                this.physicalClose(channel);
            } else if (RabbitUtils.isPhysicalCloseRequired()) {
                this.physicalClose(channel);
                if (transactional) {
                    this.txChannels.remove();
                } else {
                    this.channels.remove();
                }
                RabbitUtils.clearPhysicalCloseRequired();
            }
        }

        @Override
        public void close() {
        }

        @Override
        public void closeThreadChannel() {
            this.doClose(this.channels);
            this.doClose(this.txChannels);
        }

        private void doClose(ThreadLocal<Channel> channelsTL) {
            Channel channel = channelsTL.get();
            if (channel != null) {
                channelsTL.remove();
                this.physicalClose(channel);
            }
        }

        private void physicalClose(Channel channel) {
            if (channel.isOpen()) {
                try {
                    channel.close();
                }
                catch (IOException | TimeoutException e) {
                    ThreadChannelConnectionFactory.this.logger.debug((Object)"Error on close", (Throwable)e);
                }
            }
        }

        void forceClose() {
            super.close();
        }
    }
}

