/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.TraversableLike;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import spire.math.NumberTag;
import spire.math.Rational;
import spire.math.Rational$;
import spire.math.Real;
import spire.math.RealAlgebra;
import spire.math.RealInstances;
import spire.math.SafeLong;
import spire.math.SafeLong$;
import spire.math.package$;

public final class Real$
implements RealInstances,
scala.Serializable {
    public static Real$ MODULE$;
    private Real pi;
    private Real e;
    private Real phi;
    private Real piBy2;
    private Real piBy4;
    private Real log2;
    private Real sqrt1By2;
    private final Real zero;
    private final Real one;
    private final Real two;
    private final Real four;
    private final RealAlgebra algebra;
    private final NumberTag.LargeTag<Real> RealTag;
    private volatile byte bitmap$0;

    static {
        new Real$();
    }

    @Override
    public final RealAlgebra algebra() {
        return this.algebra;
    }

    @Override
    public final NumberTag.LargeTag<Real> RealTag() {
        return this.RealTag;
    }

    @Override
    public final void spire$math$RealInstances$_setter_$algebra_$eq(RealAlgebra x$1) {
        this.algebra = x$1;
    }

    @Override
    public final void spire$math$RealInstances$_setter_$RealTag_$eq(NumberTag.LargeTag<Real> x$1) {
        this.RealTag = x$1;
    }

    public Real zero() {
        return this.zero;
    }

    public Real one() {
        return this.one;
    }

    public Real two() {
        return this.two;
    }

    public Real four() {
        return this.four;
    }

    public Real apply(Function1<Object, SafeLong> f) {
        return new Real.Inexact(f);
    }

    public Real apply(int n) {
        return new Real.Exact(Rational$.MODULE$.apply(n));
    }

    public Real apply(long n) {
        return new Real.Exact(Rational$.MODULE$.apply(n));
    }

    public Real apply(BigInt n) {
        return new Real.Exact(Rational$.MODULE$.apply(n));
    }

    public Real apply(SafeLong n) {
        return new Real.Exact(Rational$.MODULE$.apply(n));
    }

    public Real apply(Rational n) {
        return new Real.Exact(n);
    }

    public Real apply(double n) {
        return new Real.Exact(Rational$.MODULE$.apply(n));
    }

    public Real apply(BigDecimal n) {
        return new Real.Exact(Rational$.MODULE$.apply(n));
    }

    public Real apply(String s) {
        return new Real.Exact(Rational$.MODULE$.apply(s));
    }

    private Real pi$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.pi = this.apply(16).$times(this.atan(this.apply(Rational$.MODULE$.apply(1L, 5L)))).$minus(this.four().$times(this.atan(this.apply(Rational$.MODULE$.apply(1L, 239L)))));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.pi;
    }

    public Real pi() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.pi$lzycompute();
        }
        return this.pi;
    }

    private Real e$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.e = this.exp(this.one());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.e;
    }

    public Real e() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.e$lzycompute();
        }
        return this.e;
    }

    private Real phi$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.phi = this.one().$plus(this.apply(5).sqrt()).$div(this.two());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.phi;
    }

    public Real phi() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.phi$lzycompute();
        }
        return this.phi;
    }

    public Real log(Real x) {
        SafeLong t = x.apply(2);
        int n = this.sizeInBase(t, 2) - 3;
        if (t.$less((Object)SafeLong$.MODULE$.apply(0L))) {
            throw new ArithmeticException("log of negative number");
        }
        if (t.$less((Object)SafeLong$.MODULE$.apply(4L))) {
            return this.log(x.reciprocal()).unary_$minus();
        }
        if (t.$less((Object)SafeLong$.MODULE$.apply(8L))) {
            return this.logDr(x);
        }
        return this.logDr(this.div2n(x, n)).$plus(this.apply(n).$times(this.log2()));
    }

    public Real exp(Real x) {
        SafeLong n = x.$div(this.log2()).apply(0);
        Real s = x.$minus(this.apply(n).$times(this.log2()));
        if (!n.isValidInt()) {
            throw new ArithmeticException("invalid power in exp");
        }
        if (n.$less((Object)SafeLong$.MODULE$.apply(0L))) {
            return this.div2n(this.expDr(s), -n.toInt());
        }
        if (n.$greater((Object)SafeLong$.MODULE$.apply(0L))) {
            return this.mul2n(this.expDr(s), n.toInt());
        }
        return this.expDr(s);
    }

    public Real sin(Real x) {
        Real z = x.$div(this.piBy4());
        SafeLong s = this.roundUp(Rational$.MODULE$.apply(z.apply(2), SafeLong$.MODULE$.apply(4L)));
        Real y = x.$minus(this.piBy4().$times(this.apply(s)));
        int m = s.$percent(8L).toInt();
        int n = m < 0 ? m + 8 : m;
        switch (n) {
            case 0: {
                return this.sinDr(y);
            }
            case 1: {
                return this.sqrt1By2().$times(this.cosDr(y).$plus(this.sinDr(y)));
            }
            case 2: {
                return this.cosDr(y);
            }
            case 3: {
                return this.sqrt1By2().$times(this.cosDr(y).$minus(this.sinDr(y)));
            }
            case 4: {
                return this.sinDr(y).unary_$minus();
            }
            case 5: {
                return this.sqrt1By2().unary_$minus().$times(this.cosDr(y).$plus(this.sinDr(y)));
            }
            case 6: {
                return this.cosDr(y).unary_$minus();
            }
            case 7: {
                return this.sqrt1By2().unary_$minus().$times(this.cosDr(y).$minus(this.sinDr(y)));
            }
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
    }

    public Real cos(Real x) {
        Real z = x.$div(this.piBy4());
        SafeLong s = this.roundUp(Rational$.MODULE$.apply(z.apply(2), SafeLong$.MODULE$.apply(4L)));
        Real y = x.$minus(this.piBy4().$times(this.apply(s)));
        int m = s.$percent(8L).toInt();
        int n = m < 0 ? m + 8 : m;
        switch (n) {
            case 0: {
                return this.cosDr(y);
            }
            case 1: {
                return this.sqrt1By2().$times(this.cosDr(y).$minus(this.sinDr(y)));
            }
            case 2: {
                return this.sinDr(y).unary_$minus();
            }
            case 3: {
                return this.sqrt1By2().unary_$minus().$times(this.cosDr(y).$plus(this.sinDr(y)));
            }
            case 4: {
                return this.cosDr(y).unary_$minus();
            }
            case 5: {
                return this.sqrt1By2().unary_$minus().$times(this.cosDr(y).$minus(this.sinDr(y)));
            }
            case 6: {
                return this.sinDr(y);
            }
            case 7: {
                return this.sqrt1By2().$times(this.cosDr(y).$plus(this.sinDr(y)));
            }
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
    }

    public Real tan(Real x) {
        return this.sin(x).$div(this.cos(x));
    }

    public Real atan(Real x) {
        SafeLong t = x.apply(2);
        Real xp1 = x.$plus(this.one());
        Real xm1 = x.$minus(this.one());
        if (t.$less((Object)SafeLong$.MODULE$.apply(-5L))) {
            return this.atanDr(x.reciprocal().unary_$minus()).$minus(this.piBy2());
        }
        if (BoxesRunTime.equalsNumObject((Number)((Object)t), (Object)BoxesRunTime.boxToInteger((int)-4))) {
            return this.piBy4().unary_$minus().$minus(this.atanDr(xp1.$div(xm1)));
        }
        if (t.$less((Object)SafeLong$.MODULE$.apply(4L))) {
            return this.atanDr(x);
        }
        if (BoxesRunTime.equalsNumObject((Number)((Object)t), (Object)BoxesRunTime.boxToInteger((int)4))) {
            return this.piBy4().$plus(this.atanDr(xm1.$div(xp1)));
        }
        return this.piBy2().$minus(this.atanDr(x.reciprocal()));
    }

    public Real atan2(Real y, Real x) {
        Function1 & Serializable & scala.Serializable apply_f = (Function1 & Serializable & scala.Serializable)p -> Real$.$anonfun$atan2$1(this, y, x, BoxesRunTime.unboxToInt((Object)p));
        return new Real.Inexact((Function1<Object, SafeLong>)apply_f);
    }

    public Real asin(Real x) {
        SafeLong x0 = x.apply(0);
        Real s = this.one().$minus(x.$times(x)).sqrt();
        int n = x0.signum();
        Real real = n > 0 ? this.pi().$div(this.two()).$minus(this.atan(s.$div(x))) : (0 == n ? this.atan(x.$div(s)) : this.pi().unary_$minus().$div(this.two()).$minus(this.atan(s.$div(x))));
        return real;
    }

    public Real acos(Real x) {
        return this.pi().$div(this.two()).$minus(this.asin(x));
    }

    public Real sinh(Real x) {
        Real y = this.exp(x);
        return y.$minus(y.reciprocal()).$div(this.two());
    }

    public Real cosh(Real x) {
        Real y = this.exp(x);
        return y.$plus(y.reciprocal()).$div(this.two());
    }

    public Real tanh(Real x) {
        Real y = this.exp(x);
        Real y2 = y.reciprocal();
        return y.$minus(y2).$div(y.$plus(y2));
    }

    public Real asinh(Real x) {
        return this.log(x.$plus(x.$times(x).$plus(this.one()).sqrt()));
    }

    public Real acosh(Real x) {
        return this.log(x.$plus(x.$times(x).$minus(this.one()).sqrt()));
    }

    public Real atanh(Real x) {
        return this.log(this.one().$plus(x).$div(this.one().$minus(x))).$div(this.two());
    }

    public int digits() {
        return 40;
    }

    public int bits() {
        return this.digitsToBits(this.digits());
    }

    public int digitsToBits(int n) {
        return (int)package$.MODULE$.ceil((double)n * (package$.MODULE$.log(10.0) / package$.MODULE$.log(2.0))) + 4;
    }

    public int sizeInBase(SafeLong n, int base) {
        return this.loop$2(n.abs(), 0, base);
    }

    public SafeLong roundUp(Rational r) {
        return SafeLong$.MODULE$.apply(r.round().toBigInt());
    }

    public Real div2n(Real x, int n) {
        Function1 & Serializable & scala.Serializable apply_f = (Function1 & Serializable & scala.Serializable)p -> Real$.$anonfun$div2n$1(this, x, n, BoxesRunTime.unboxToInt((Object)p));
        return new Real.Inexact((Function1<Object, SafeLong>)apply_f);
    }

    public Real mul2n(Real x, int n) {
        Function1 & Serializable & scala.Serializable apply_f = (Function1 & Serializable & scala.Serializable)p -> x.apply(BoxesRunTime.unboxToInt((Object)p) + n);
        return new Real.Inexact((Function1<Object, SafeLong>)apply_f);
    }

    private Real piBy2$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.piBy2 = this.div2n(this.pi(), 1);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.piBy2;
    }

    public Real piBy2() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.piBy2$lzycompute();
        }
        return this.piBy2;
    }

    private Real piBy4$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.piBy4 = this.div2n(this.pi(), 2);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.piBy4;
    }

    public Real piBy4() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.piBy4$lzycompute();
        }
        return this.piBy4;
    }

    private Real log2$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.log2 = this.div2n(this.logDrx(this.two().reciprocal()), 1);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.log2;
    }

    public Real log2() {
        if ((byte)(this.bitmap$0 & 0x20) == 0) {
            return this.log2$lzycompute();
        }
        return this.log2;
    }

    private Real sqrt1By2$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                this.sqrt1By2 = this.two().reciprocal().sqrt();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
            }
        }
        return this.sqrt1By2;
    }

    public Real sqrt1By2() {
        if ((byte)(this.bitmap$0 & 0x40) == 0) {
            return this.sqrt1By2$lzycompute();
        }
        return this.sqrt1By2;
    }

    public SafeLong accumulate(SafeLong total, Stream<SafeLong> xs, Stream<Rational> cs) {
        block3: {
            Tuple2 tuple2;
            while (true) {
                Option option;
                tuple2 = new Tuple2(xs, cs);
                if (Stream.Empty$.MODULE$.equals(cs)) break block3;
                if (Stream.Empty$.MODULE$.equals(xs)) {
                    throw scala.sys.package$.MODULE$.error("nooooo");
                }
                Option option2 = scala.package$.MODULE$.$hash$colon$colon().unapply(xs);
                if (option2.isEmpty() || (option = scala.package$.MODULE$.$hash$colon$colon().unapply(cs)).isEmpty()) break;
                SafeLong t = this.roundUp(((Rational)((Object)((Tuple2)option.get())._1())).$times(Rational$.MODULE$.apply((SafeLong)((Object)((Tuple2)option2.get())._1()))));
                if (!BoxesRunTime.equalsNumObject((Number)((Object)t), (Object)BoxesRunTime.boxToInteger((int)0))) {
                    cs = (Stream)((Tuple2)option.get())._2();
                    xs = (Stream)((Tuple2)option2.get())._2();
                    total = total.$plus(t);
                    continue;
                }
                break block3;
                break;
            }
            throw new MatchError((Object)tuple2);
        }
        return total;
    }

    public Real powerSeries(Stream<Rational> ps, Function1<Object, Object> terms, Real x) {
        Function1 & Serializable & scala.Serializable apply_f = (Function1 & Serializable & scala.Serializable)p -> {
            void $anonfun$powerSeries$1_iterate_apply_tl;
            void $anonfun$powerSeries$1_iterate_f;
            int $anonfun$powerSeries$1_p = BoxesRunTime.unboxToInt((Object)p);
            int $anonfun$powerSeries$1_t = terms.apply$mcII$sp($anonfun$powerSeries$1_p);
            int $anonfun$powerSeries$1_l2t = 2 * this.sizeInBase(SafeLong$.MODULE$.apply($anonfun$powerSeries$1_t).$plus(1L), 2) + 6;
            int $anonfun$powerSeries$1_p2 = $anonfun$powerSeries$1_p + $anonfun$powerSeries$1_l2t;
            SafeLong $anonfun$powerSeries$1_xr = x.apply($anonfun$powerSeries$1_p2);
            SafeLong $anonfun$powerSeries$1_xn = SafeLong$.MODULE$.two().pow($anonfun$powerSeries$1_p2);
            if (BoxesRunTime.equalsNumObject((Number)((Object)$anonfun$powerSeries$1_xn), (Object)BoxesRunTime.boxToInteger((int)0))) {
                throw scala.sys.package$.MODULE$.error("oh no");
            }
            Stream$ stream$ = scala.package$.MODULE$.Stream();
            Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)yn -> this.g$1((SafeLong)((Object)((Object)((Object)yn))), xr, xn);
            if (stream$ == null) {
                throw null;
            }
            Stream$ $anonfun$powerSeries$1_iterate_this = stream$;
            Function0 & Serializable & scala.Serializable intersect2 = () -> Stream$.$anonfun$iterate$1((Stream$)$anonfun$powerSeries$1_iterate_this, (Object)((Object)$anonfun$powerSeries$1_xn), (Function1)$anonfun$powerSeries$1_iterate_f);
            if (Stream.cons$.MODULE$ == null) {
                throw null;
            }
            SafeLong $anonfun$powerSeries$1_num = this.accumulate(SafeLong$.MODULE$.zero(), (Stream<SafeLong>)new Stream.Cons((Object)$anonfun$powerSeries$1_xn, (Function0)$anonfun$powerSeries$1_iterate_apply_tl), (Stream<Rational>)ps.take($anonfun$powerSeries$1_t));
            SafeLong $anonfun$powerSeries$1_denom = SafeLong$.MODULE$.two().pow($anonfun$powerSeries$1_l2t);
            return this.roundUp(Rational$.MODULE$.apply($anonfun$powerSeries$1_num, $anonfun$powerSeries$1_denom));
        };
        return new Real.Inexact((Function1<Object, SafeLong>)apply_f);
    }

    /*
     * WARNING - void declaration
     */
    public Stream<Rational> accSeq(Function2<Rational, SafeLong, Rational> f) {
        void loop$3_consWrapper_stream;
        SafeLong loop$3_n = SafeLong$.MODULE$.one();
        Rational loop$3_r = Rational$.MODULE$.one();
        Function0 & Serializable & scala.Serializable intersect = (Function0 & Serializable & scala.Serializable)() -> {
            void loop$3_consWrapper_stream;
            void loop$3_n;
            SafeLong safeLong = loop$3_n.$plus(1L);
            Rational loop$3_r = (Rational)((Object)((Object)((Object)f.apply((Object)loop$3_r, (Object)loop$3_n))));
            Function0 & Serializable & scala.Serializable intersect = () -> Real$.$anonfun$accSeq$1(f, loop$3_r, (SafeLong)loop$3_n);
            if (Stream$.MODULE$ == null) {
                throw null;
            }
            return new Stream.ConsWrapper((Function0)loop$3_consWrapper_stream).$hash$colon$colon((Object)loop$3_r);
        };
        if (Stream$.MODULE$ == null) {
            throw null;
        }
        return new Stream.ConsWrapper((Function0)loop$3_consWrapper_stream).$hash$colon$colon((Object)loop$3_r);
    }

    /*
     * WARNING - void declaration
     */
    public Real expDr(Real x) {
        void accSeq_loop$3_consWrapper_stream;
        void accSeq_loop$3_n;
        Function2 & Serializable & scala.Serializable accSeq_f = (Function2 & Serializable & scala.Serializable)(r, n) -> r.$div(Rational$.MODULE$.apply((SafeLong)((Object)n)));
        SafeLong safeLong = SafeLong$.MODULE$.one();
        Rational accSeq_loop$3_r = Rational$.MODULE$.one();
        Function0 & Serializable & scala.Serializable intersect = () -> Real$.$anonfun$accSeq$1(accSeq_f, accSeq_loop$3_r, (SafeLong)accSeq_loop$3_n);
        if (Stream$.MODULE$ == null) {
            throw null;
        }
        Stream stream = new Stream.ConsWrapper((Function0)accSeq_loop$3_consWrapper_stream).$hash$colon$colon((Object)accSeq_loop$3_r);
        JFunction1.mcII.sp & Serializable & scala.Serializable powerSeries_terms = (JFunction1.mcII.sp & Serializable & scala.Serializable)n -> n;
        Function1 & Serializable & scala.Serializable powerSeries_apply_f = arg_0 -> Real$.$anonfun$powerSeries$1$adapted(this, stream, (Function1)powerSeries_terms, x, arg_0);
        return new Real.Inexact((Function1<Object, SafeLong>)powerSeries_apply_f);
    }

    public Real logDr(Real x) {
        Real y = x.$minus(this.one()).$div(x);
        return y.$times(this.logDrx(y));
    }

    /*
     * WARNING - void declaration
     */
    public Real logDrx(Real x) {
        void powerSeries_terms;
        void map_f;
        Object object;
        void map_bf;
        Stream stream = scala.package$.MODULE$.Stream().from(1);
        CanBuildFrom canBuildFrom = Stream$.MODULE$.canBuildFrom();
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)n -> Rational$.MODULE$.apply(1L, BoxesRunTime.unboxToInt((Object)n));
        if (stream == null) {
            throw null;
        }
        Stream map_this = stream;
        if (map_bf.apply(map_this.repr()) instanceof Stream.StreamBuilder) {
            if (map_this.isEmpty()) {
                object = Stream.Empty$.MODULE$;
            } else {
                void map_apply_tl;
                Rational rational = Rational$.MODULE$.apply(1L, BoxesRunTime.unboxToInt((Object)map_this.head()));
                Function0 & Serializable & scala.Serializable intersect2 = () -> Stream.$anonfun$map$1((Stream)map_this, (Function1)map_f);
                if (Stream.cons$.MODULE$ == null) {
                    throw null;
                }
                object = new Stream.Cons((Object)rational, (Function0)map_apply_tl);
            }
        } else {
            object = TraversableLike.map$((TraversableLike)map_this, (Function1)map_f, (CanBuildFrom)map_bf);
        }
        JFunction1.mcII.sp & Serializable & scala.Serializable intersect3 = (JFunction1.mcII.sp & Serializable & scala.Serializable)x$3 -> x$3 + 1;
        Stream powerSeries_ps = (Stream)object;
        Function1 & Serializable & scala.Serializable powerSeries_apply_f = arg_0 -> Real$.$anonfun$powerSeries$1$adapted(this, powerSeries_ps, (Function1)powerSeries_terms, x, arg_0);
        return new Real.Inexact((Function1<Object, SafeLong>)powerSeries_apply_f);
    }

    /*
     * WARNING - void declaration
     */
    public Real sinDr(Real x) {
        void accSeq_loop$3_consWrapper_stream;
        void accSeq_loop$3_n;
        Function2 & Serializable & scala.Serializable accSeq_f = (Function2 & Serializable & scala.Serializable)(r, n) -> r.unary_$minus().$times(Rational$.MODULE$.apply(SafeLong$.MODULE$.apply(1L), SafeLong$.MODULE$.apply(2L).$times((SafeLong)((Object)n)).$times(SafeLong$.MODULE$.apply(2L).$times((SafeLong)((Object)n)).$plus(1L))));
        SafeLong safeLong = SafeLong$.MODULE$.one();
        Rational accSeq_loop$3_r = Rational$.MODULE$.one();
        Function0 & Serializable & scala.Serializable intersect = () -> Real$.$anonfun$accSeq$1(accSeq_f, accSeq_loop$3_r, (SafeLong)accSeq_loop$3_n);
        if (Stream$.MODULE$ == null) {
            throw null;
        }
        Stream stream = new Stream.ConsWrapper((Function0)accSeq_loop$3_consWrapper_stream).$hash$colon$colon((Object)accSeq_loop$3_r);
        Real powerSeries_x = x.$times(x);
        JFunction1.mcII.sp & Serializable & scala.Serializable powerSeries_terms = (JFunction1.mcII.sp & Serializable & scala.Serializable)n -> n;
        Function1 & Serializable & scala.Serializable powerSeries_apply_f = arg_0 -> Real$.$anonfun$powerSeries$1$adapted(this, stream, (Function1)powerSeries_terms, powerSeries_x, arg_0);
        return x.$times(new Real.Inexact((Function1<Object, SafeLong>)powerSeries_apply_f));
    }

    /*
     * WARNING - void declaration
     */
    public Real cosDr(Real x) {
        void accSeq_loop$3_consWrapper_stream;
        void accSeq_loop$3_n;
        Function2 & Serializable & scala.Serializable accSeq_f = (Function2 & Serializable & scala.Serializable)(r, n) -> r.unary_$minus().$times(Rational$.MODULE$.apply(SafeLong$.MODULE$.apply(1L), SafeLong$.MODULE$.apply(2L).$times((SafeLong)((Object)n)).$times(SafeLong$.MODULE$.apply(2L).$times((SafeLong)((Object)n)).$minus(1L))));
        SafeLong safeLong = SafeLong$.MODULE$.one();
        Rational accSeq_loop$3_r = Rational$.MODULE$.one();
        Function0 & Serializable & scala.Serializable intersect = () -> Real$.$anonfun$accSeq$1(accSeq_f, accSeq_loop$3_r, (SafeLong)accSeq_loop$3_n);
        if (Stream$.MODULE$ == null) {
            throw null;
        }
        Stream stream = new Stream.ConsWrapper((Function0)accSeq_loop$3_consWrapper_stream).$hash$colon$colon((Object)accSeq_loop$3_r);
        Real powerSeries_x = x.$times(x);
        JFunction1.mcII.sp & Serializable & scala.Serializable powerSeries_terms = (JFunction1.mcII.sp & Serializable & scala.Serializable)n -> n;
        Function1 & Serializable & scala.Serializable powerSeries_apply_f = arg_0 -> Real$.$anonfun$powerSeries$1$adapted(this, stream, (Function1)powerSeries_terms, powerSeries_x, arg_0);
        return new Real.Inexact((Function1<Object, SafeLong>)powerSeries_apply_f);
    }

    public Real atanDr(Real x) {
        Real y = x.$times(x).$plus(this.apply(1));
        return x.$div(y).$times(this.atanDrx(x.$times(x).$div(y)));
    }

    /*
     * WARNING - void declaration
     */
    public Real atanDrx(Real x) {
        void accSeq_loop$3_consWrapper_stream;
        void accSeq_loop$3_n;
        Function2 & Serializable & scala.Serializable accSeq_f = (Function2 & Serializable & scala.Serializable)(r, n) -> r.$times(Rational$.MODULE$.apply(SafeLong$.MODULE$.apply(2L).$times((SafeLong)((Object)n)), SafeLong$.MODULE$.apply(2L).$times((SafeLong)((Object)n)).$plus(1L)));
        SafeLong safeLong = SafeLong$.MODULE$.one();
        Rational accSeq_loop$3_r = Rational$.MODULE$.one();
        Function0 & Serializable & scala.Serializable intersect = () -> Real$.$anonfun$accSeq$1(accSeq_f, accSeq_loop$3_r, (SafeLong)accSeq_loop$3_n);
        if (Stream$.MODULE$ == null) {
            throw null;
        }
        Stream stream = new Stream.ConsWrapper((Function0)accSeq_loop$3_consWrapper_stream).$hash$colon$colon((Object)accSeq_loop$3_r);
        JFunction1.mcII.sp & Serializable & scala.Serializable powerSeries_terms = (JFunction1.mcII.sp & Serializable & scala.Serializable)x$4 -> x$4 * 2;
        Function1 & Serializable & scala.Serializable powerSeries_apply_f = arg_0 -> Real$.$anonfun$powerSeries$1$adapted(this, stream, (Function1)powerSeries_terms, x, arg_0);
        return new Real.Inexact((Function1<Object, SafeLong>)powerSeries_apply_f);
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ SafeLong $anonfun$atan2$1(Real$ $this, Real y$9, Real x$7, int p) {
        int pp = p;
        int sx = x$7.apply(p).signum();
        int sy = y$9.apply(p).signum();
        while (sx == 0 && sy == 0) {
            sx = x$7.apply(pp).signum();
            sy = y$9.apply(pp).signum();
            ++pp;
        }
        if (sx > 0) {
            return $this.atan(y$9.$div(x$7)).apply(p);
        }
        if (sy >= 0 && sx < 0) {
            return $this.atan(y$9.$div(x$7)).$plus(MODULE$.pi()).apply(p);
        }
        if (sy < 0 && sx < 0) {
            return $this.atan(y$9.$div(x$7)).$minus(MODULE$.pi()).apply(p);
        }
        if (sy > 0) {
            return MODULE$.pi().$div(MODULE$.two()).apply(p);
        }
        if (sy < 0) {
            return MODULE$.pi().unary_$minus().$div(MODULE$.two()).apply(p);
        }
        throw new IllegalArgumentException("atan2(0, 0) is undefined");
    }

    private final int loop$2(SafeLong n, int acc, int base$1) {
        while (!n.$less$eq((Object)SafeLong$.MODULE$.apply(1L))) {
            ++acc;
            n = n.$div(base$1);
        }
        return acc + 1;
    }

    public static final /* synthetic */ SafeLong $anonfun$div2n$1(Real$ $this, Real x$5, int n$1, int p) {
        if (p >= n$1) {
            return x$5.apply(p - n$1);
        }
        return $this.roundUp(Rational$.MODULE$.apply(x$5.apply(p), SafeLong$.MODULE$.two().pow(n$1)));
    }

    private final SafeLong g$1(SafeLong yn, SafeLong xr$1, SafeLong xn$1) {
        return this.roundUp(Rational$.MODULE$.apply(yn.$times(xr$1), xn$1));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ SafeLong $anonfun$powerSeries$1(Real$ $this, Stream ps$1, Function1 terms$1, Real x$8, int p) {
        void iterate_apply_tl;
        void iterate_f;
        int t = terms$1.apply$mcII$sp(p);
        int l2t = 2 * $this.sizeInBase(SafeLong$.MODULE$.apply(t).$plus(1L), 2) + 6;
        int p2 = p + l2t;
        SafeLong xr = x$8.apply(p2);
        SafeLong xn = SafeLong$.MODULE$.two().pow(p2);
        if (BoxesRunTime.equalsNumObject((Number)((Object)xn), (Object)BoxesRunTime.boxToInteger((int)0))) {
            throw scala.sys.package$.MODULE$.error("oh no");
        }
        Stream$ stream$ = scala.package$.MODULE$.Stream();
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)yn -> this.g$1((SafeLong)((Object)((Object)((Object)yn))), xr, xn);
        if (stream$ == null) {
            throw null;
        }
        Stream$ iterate_this = stream$;
        Function0 & Serializable & scala.Serializable intersect2 = () -> Stream$.$anonfun$iterate$1((Stream$)iterate_this, (Object)((Object)xn), (Function1)iterate_f);
        if (Stream.cons$.MODULE$ == null) {
            throw null;
        }
        SafeLong num = $this.accumulate(SafeLong$.MODULE$.zero(), (Stream<SafeLong>)new Stream.Cons((Object)xn, (Function0)iterate_apply_tl), (Stream<Rational>)ps$1.take(t));
        SafeLong denom = SafeLong$.MODULE$.two().pow(l2t);
        return $this.roundUp(Rational$.MODULE$.apply(num, denom));
    }

    /*
     * WARNING - void declaration
     */
    private static final Stream loop$3(Rational r, SafeLong n, Function2 f$1) {
        void consWrapper_stream;
        Function0 & Serializable & scala.Serializable intersect = (Function0 & Serializable & scala.Serializable)() -> {
            void loop$3_consWrapper_stream;
            void loop$3_n;
            SafeLong safeLong = loop$3_n.$plus(1L);
            Rational loop$3_r = (Rational)((Object)((Object)((Object)f.apply((Object)loop$3_r, (Object)loop$3_n))));
            Function0 & Serializable & scala.Serializable intersect = () -> Real$.$anonfun$accSeq$1(f, loop$3_r, (SafeLong)loop$3_n);
            if (Stream$.MODULE$ == null) {
                throw null;
            }
            return new Stream.ConsWrapper((Function0)loop$3_consWrapper_stream).$hash$colon$colon((Object)loop$3_r);
        };
        if (Stream$.MODULE$ == null) {
            throw null;
        }
        return new Stream.ConsWrapper((Function0)consWrapper_stream).$hash$colon$colon((Object)r);
    }

    private Real$() {
        MODULE$ = this;
        RealInstances.$init$(this);
        this.zero = new Real.Exact(Rational$.MODULE$.zero());
        this.one = new Real.Exact(Rational$.MODULE$.one());
        this.two = new Real.Exact(Rational$.MODULE$.apply(2));
        this.four = new Real.Exact(Rational$.MODULE$.apply(4));
    }
}

