/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo;

import java.util.Arrays;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOTable;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;

public class DefaultMOTableRow
implements MOTableRow,
Comparable<MOTableRow> {
    protected Variable[] values;
    protected OID index;

    public DefaultMOTableRow(OID index, Variable[] values) {
        this.index = index;
        this.values = values;
    }

    @Override
    public MOTableRow getBaseRow() {
        return null;
    }

    @Override
    public OID getIndex() {
        return this.index;
    }

    @Override
    public Variable getValue(int column) {
        return this.values[column];
    }

    @Override
    public int size() {
        return this.values.length;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MOTableRow) {
            MOTableRow other = (MOTableRow)obj;
            boolean equals = other.getIndex().equals((Object)this.index);
            if (equals &= this.size() == other.size()) {
                for (int i = 0; equals && i < this.size(); ++i) {
                    Variable v1 = this.getValue(i);
                    Variable v2 = other.getValue(i);
                    equals = v1 == null && v2 == null || v1 != null && v1.equals((Object)v2);
                }
            }
            return equals;
        }
        return false;
    }

    public int hashCode() {
        return this.index.hashCode();
    }

    public String toString() {
        return "DefaultMOTableRow[" + this.toStringMembers();
    }

    protected String toStringMembers() {
        return "index=" + this.index + ",values=" + Arrays.asList(this.values);
    }

    @Override
    public void setBaseRow(MOTableRow baseRow) {
    }

    @Override
    public int compareTo(MOTableRow o) {
        return this.getIndex().compareTo((Variable)o.getIndex());
    }

    public static <V extends Variable> V getColumnValue(MOTableRow row, MOTable<?, ?, ?> table, Class<MOColumn<V>> columnClass, SubRequest<?> subRequest) {
        int colID = 0;
        for (MOColumn moColumn : table.getColumns()) {
            if (moColumn.getClass().equals(columnClass)) {
                return columnClass.cast(moColumn).getValue(row, colID, subRequest);
            }
            ++colID;
        }
        return null;
    }
}

