/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent;

import org.snmp4j.CommandResponderEvent;
import org.snmp4j.PDU;
import org.snmp4j.agent.mo.snmp.CoexistenceInfo;
import org.snmp4j.agent.request.SnmpRequest;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;

public class ProxyForwardRequest<A extends Address> {
    private CommandResponderEvent<A> commandEvent;
    private PDU responsePDU;
    private CoexistenceInfo coexistenceInfo;
    private int proxyType;

    public ProxyForwardRequest(CommandResponderEvent<A> commandEvent, CoexistenceInfo coexistenceInfo) {
        this.commandEvent = commandEvent;
        this.coexistenceInfo = coexistenceInfo;
        this.setProxyType();
    }

    public CommandResponderEvent<A> getCommandEvent() {
        return this.commandEvent;
    }

    public void setResponsePDU(PDU responsePDU) {
        this.responsePDU = responsePDU;
    }

    public PDU getResponsePDU() {
        return this.responsePDU;
    }

    public OctetString getContextEngineID() {
        return this.coexistenceInfo.getContextEngineID();
    }

    public OctetString getContext() {
        return this.coexistenceInfo.getContextName();
    }

    public OctetString getSecurityName() {
        return this.coexistenceInfo.getSecurityName();
    }

    public CoexistenceInfo getCoexistenceInfo() {
        return this.coexistenceInfo;
    }

    public int getProxyType() {
        return this.proxyType;
    }

    private void setProxyType() {
        int viewType = SnmpRequest.getViewType(this.commandEvent.getPDU().getType());
        switch (viewType) {
            case 2: {
                this.proxyType = 2;
                break;
            }
            case 0: {
                if (this.commandEvent.getPDU().getType() == -90) {
                    this.proxyType = 4;
                    break;
                }
                this.proxyType = 3;
                break;
            }
            default: {
                this.proxyType = 1;
            }
        }
    }

    public String toString() {
        return ProxyForwardRequest.class.getName() + "[coexistenceInfo=" + this.coexistenceInfo + ",proxyType=" + this.proxyType + ",commandEvent=" + this.commandEvent + "]";
    }
}

