/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport;

import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;
import org.simpleframework.transport.Certificate;
import org.simpleframework.transport.CertificateChallenge;
import org.simpleframework.transport.Negotiation;
import org.simpleframework.transport.Socket;
import org.simpleframework.transport.TransportEvent;
import org.simpleframework.transport.trace.Trace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NegotiationState
implements Certificate {
    private final RunnableFuture<Certificate> future;
    private final Negotiation negotiation;
    private final Challenge challenge;
    private final Delegate delegate;
    private final Socket socket;

    public NegotiationState(Negotiation negotiation, Socket socket) {
        this.delegate = new Delegate(socket);
        this.future = new FutureTask<NegotiationState>(this.delegate, this);
        this.challenge = new Challenge(socket);
        this.negotiation = negotiation;
        this.socket = socket;
    }

    public boolean isChallenge() {
        return this.delegate.isSet();
    }

    public RunnableFuture<Certificate> getFuture() {
        return this.future;
    }

    @Override
    public CertificateChallenge getChallenge() throws Exception {
        return this.challenge;
    }

    @Override
    public X509Certificate[] getChain() throws Exception {
        SSLSession session = this.getSession();
        if (session != null) {
            return session.getPeerCertificateChain();
        }
        return null;
    }

    public SSLSession getSession() throws Exception {
        SSLEngine engine = this.socket.getEngine();
        if (engine != null) {
            return engine.getSession();
        }
        return null;
    }

    @Override
    public boolean isChainPresent() {
        try {
            return this.getChain() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private class Delegate
    implements Runnable {
        private final AtomicReference<Runnable> task = new AtomicReference();
        private final AtomicBoolean ready = new AtomicBoolean();
        private final Trace trace;

        public Delegate(Socket socket) {
            this.trace = socket.getTrace();
        }

        public boolean isSet() {
            return this.ready.get();
        }

        public void set(Runnable runnable) {
            this.ready.set(true);
            this.task.set(runnable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Runnable runnable = this.task.get();
                if (runnable != null) {
                    runnable.run();
                }
            }
            catch (Exception cause) {
                this.trace.trace((Object)TransportEvent.ERROR, cause);
            }
            finally {
                this.task.set(null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Challenge
    implements CertificateChallenge {
        private final SSLEngine engine;
        private final Trace trace;

        public Challenge(Socket socket) {
            this.engine = socket.getEngine();
            this.trace = socket.getTrace();
        }

        @Override
        public Future<Certificate> challenge() {
            return this.challenge(null);
        }

        @Override
        public Future<Certificate> challenge(Runnable task) {
            try {
                if (!NegotiationState.this.isChainPresent()) {
                    this.resume(task);
                } else {
                    NegotiationState.this.future.run();
                }
            }
            catch (Exception cause) {
                this.trace.trace((Object)TransportEvent.ERROR, cause);
            }
            return NegotiationState.this.future;
        }

        private void resume(Runnable task) {
            try {
                this.trace.trace((Object)TransportEvent.CERTIFICATE_CHALLENGE);
                NegotiationState.this.delegate.set(task);
                this.engine.setNeedClientAuth(true);
                this.engine.beginHandshake();
                NegotiationState.this.negotiation.resume();
            }
            catch (Exception cause) {
                this.trace.trace((Object)TransportEvent.ERROR, cause);
                NegotiationState.this.negotiation.cancel();
            }
        }
    }
}

