/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.common.thread;

import java.util.concurrent.ThreadFactory;

public class DaemonFactory
implements ThreadFactory {
    private final Class type;

    public DaemonFactory() {
        this(null);
    }

    public DaemonFactory(Class type) {
        this.type = type;
    }

    public Thread newThread(Runnable task) {
        Thread thread = this.newThread(task, this.type);
        String name = this.createName(task, thread);
        if (!thread.isAlive()) {
            thread.setName(name);
        }
        return thread;
    }

    public Thread newThread(Runnable task, Class type) {
        Thread thread = this.createThread(task);
        String name = this.createName(type, thread);
        if (!thread.isAlive()) {
            thread.setName(name);
        }
        return thread;
    }

    private String createName(Runnable task, Thread thread) {
        Class<?> type = task.getClass();
        String prefix = type.getSimpleName();
        String name = thread.getName();
        return String.format("%s: %s", prefix, name);
    }

    private String createName(Class type, Thread thread) {
        String prefix = type.getSimpleName();
        String name = thread.getName();
        return String.format("%s: %s", prefix, name);
    }

    private Thread createThread(Runnable task) {
        return new Thread(task);
    }
}

