/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.common.buffer;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;

class FileWatcher
implements FileFilter {
    private final String prefix;
    private final long duration;

    public FileWatcher(String prefix) {
        this(prefix, 300000L);
    }

    public FileWatcher(String prefix, long duration) {
        this.duration = duration;
        this.prefix = prefix;
    }

    public File create() throws IOException {
        File parent;
        File path = this.create(this.prefix);
        if (!path.isDirectory() && (parent = path.getParentFile()).isDirectory()) {
            this.clean(parent);
        }
        return path;
    }

    private File create(String prefix) throws IOException {
        File file = File.createTempFile(prefix, null);
        if (!file.exists()) {
            file.createNewFile();
        }
        return file;
    }

    private void clean(File path) throws IOException {
        File[] list;
        for (File next : list = path.listFiles(this)) {
            for (int i = 0; i < 3 && !next.delete(); ++i) {
            }
        }
    }

    public boolean accept(File file) {
        String name = file.getName();
        if (file.isDirectory()) {
            return false;
        }
        return this.accept(file, name);
    }

    private boolean accept(File file, String name) {
        long time = System.currentTimeMillis();
        long modified = file.lastModified();
        if (modified + this.duration > time) {
            return false;
        }
        return name.startsWith(this.prefix);
    }
}

