/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.mapreduce;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RObject;
import org.redisson.api.RedissonClient;
import org.redisson.api.mapreduce.RCollator;
import org.redisson.api.mapreduce.RMapReduce;
import org.redisson.api.mapreduce.RMapper;
import org.redisson.api.mapreduce.RReducer;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.mapreduce.CoordinatorTask;
import org.redisson.mapreduce.MapReduceExecutor;
import org.redisson.mapreduce.MapperTask;

public class RedissonMapReduce<KIn, VIn, KOut, VOut>
extends MapReduceExecutor<RMapper<KIn, VIn, KOut, VOut>, VIn, KOut, VOut>
implements RMapReduce<KIn, VIn, KOut, VOut> {
    public RedissonMapReduce(RObject object, RedissonClient redisson, CommandAsyncExecutor commandExecutor) {
        super(object, redisson, commandExecutor);
    }

    @Override
    public RMapReduce<KIn, VIn, KOut, VOut> timeout(long timeout, TimeUnit unit) {
        this.timeout = unit.toMillis(timeout);
        return this;
    }

    @Override
    public RMapReduce<KIn, VIn, KOut, VOut> mapper(RMapper<KIn, VIn, KOut, VOut> mapper) {
        this.check(mapper);
        this.mapper = mapper;
        return this;
    }

    @Override
    public RMapReduce<KIn, VIn, KOut, VOut> reducer(RReducer<KOut, VOut> reducer) {
        this.check(reducer);
        this.reducer = reducer;
        return this;
    }

    @Override
    protected Callable<Object> createTask(String resultMapName, RCollator<KOut, VOut, Object> collator) {
        MapperTask mapperTask = new MapperTask((RMapper)this.mapper, this.objectClass, this.objectCodec.getClass());
        return new CoordinatorTask<KOut, VOut>(mapperTask, this.reducer, this.objectName, resultMapName, this.objectCodec.getClass(), this.objectClass, collator, this.timeout, System.currentTimeMillis());
    }
}

