/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.handler;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.NetUtil;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisClientConfig;
import org.redisson.client.RedisConnection;
import org.redisson.client.handler.CommandBatchEncoder;
import org.redisson.client.handler.CommandDecoder;
import org.redisson.client.handler.CommandEncoder;
import org.redisson.client.handler.CommandPubSubDecoder;
import org.redisson.client.handler.CommandsQueue;
import org.redisson.client.handler.CommandsQueuePubSub;
import org.redisson.client.handler.ConnectionWatchdog;
import org.redisson.client.handler.ErrorsLoggingHandler;
import org.redisson.client.handler.PingConnectionHandler;
import org.redisson.client.handler.RedisConnectionHandler;
import org.redisson.client.handler.RedisPubSubConnectionHandler;
import org.redisson.config.SslProvider;

public class RedisChannelInitializer
extends ChannelInitializer<Channel> {
    private final RedisClientConfig config;
    private final RedisClient redisClient;
    private final Type type;
    private final ConnectionWatchdog connectionWatchdog;
    private final PingConnectionHandler pingConnectionHandler;

    public RedisChannelInitializer(Bootstrap bootstrap, RedisClientConfig config, RedisClient redisClient, ChannelGroup channels, Type type) {
        this.config = config;
        this.redisClient = redisClient;
        this.type = type;
        this.pingConnectionHandler = config.getPingConnectionInterval() > 0 ? new PingConnectionHandler(config) : null;
        this.connectionWatchdog = new ConnectionWatchdog(bootstrap, channels, config.getTimer());
    }

    protected void initChannel(Channel ch) throws Exception {
        this.initSsl(this.config, ch);
        if (this.type == Type.PLAIN) {
            ch.pipeline().addLast(new ChannelHandler[]{new RedisConnectionHandler(this.redisClient)});
        } else {
            ch.pipeline().addLast(new ChannelHandler[]{new RedisPubSubConnectionHandler(this.redisClient)});
        }
        ch.pipeline().addLast(new ChannelHandler[]{this.connectionWatchdog, CommandEncoder.INSTANCE, CommandBatchEncoder.INSTANCE});
        if (this.type == Type.PLAIN) {
            ch.pipeline().addLast(new ChannelHandler[]{new CommandsQueue()});
        } else {
            ch.pipeline().addLast(new ChannelHandler[]{new CommandsQueuePubSub()});
        }
        if (this.pingConnectionHandler != null) {
            ch.pipeline().addLast(new ChannelHandler[]{this.pingConnectionHandler});
        }
        if (this.type == Type.PLAIN) {
            ch.pipeline().addLast(new ChannelHandler[]{new CommandDecoder(this.config.getAddress().getScheme())});
        } else {
            ch.pipeline().addLast(new ChannelHandler[]{new CommandPubSubDecoder(this.config)});
        }
        ch.pipeline().addLast(new ChannelHandler[]{new ErrorsLoggingHandler()});
        this.config.getNettyHook().afterChannelInitialization(ch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSsl(RedisClientConfig config, Channel ch) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, SSLException, UnrecoverableKeyException {
        char[] password;
        InputStream stream;
        KeyStore keyStore;
        if (!config.getAddress().isSsl()) {
            return;
        }
        io.netty.handler.ssl.SslProvider provided = io.netty.handler.ssl.SslProvider.JDK;
        if (config.getSslProvider() == SslProvider.OPENSSL) {
            provided = io.netty.handler.ssl.SslProvider.OPENSSL;
        }
        SslContextBuilder sslContextBuilder = SslContextBuilder.forClient().sslProvider(provided);
        sslContextBuilder.protocols(config.getSslProtocols());
        if (config.getSslTruststore() != null) {
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            stream = config.getSslTruststore().openStream();
            try {
                password = null;
                if (config.getSslTruststorePassword() != null) {
                    password = config.getSslTruststorePassword().toCharArray();
                }
                keyStore.load(stream, password);
            }
            finally {
                stream.close();
            }
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            sslContextBuilder.trustManager(trustManagerFactory);
        }
        if (config.getSslKeystore() != null) {
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            stream = config.getSslKeystore().openStream();
            password = null;
            if (config.getSslKeystorePassword() != null) {
                password = config.getSslKeystorePassword().toCharArray();
            }
            try {
                keyStore.load(stream, password);
            }
            finally {
                stream.close();
            }
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, password);
            sslContextBuilder.keyManager(keyManagerFactory);
        }
        SSLParameters sslParams = new SSLParameters();
        if (config.isSslEnableEndpointIdentification()) {
            sslParams.setEndpointIdentificationAlgorithm("HTTPS");
        } else if (config.getSslTruststore() == null) {
            sslContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
        }
        SslContext sslContext = sslContextBuilder.build();
        String hostname = config.getSslHostname();
        if (hostname == null || NetUtil.createByteArrayFromIpAddressString((String)hostname) != null) {
            hostname = config.getAddress().getHost();
        }
        SSLEngine sslEngine = sslContext.newEngine(ch.alloc(), hostname, config.getAddress().getPort());
        sslEngine.setSSLParameters(sslParams);
        SslHandler sslHandler = new SslHandler(sslEngine);
        ch.pipeline().addLast(new ChannelHandler[]{sslHandler});
        ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){
            volatile boolean sslInitDone;

            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                if (this.sslInitDone) {
                    super.channelActive(ctx);
                }
            }

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                if (!this.sslInitDone && evt instanceof SslHandshakeCompletionEvent) {
                    SslHandshakeCompletionEvent e = (SslHandshakeCompletionEvent)evt;
                    if (e.isSuccess()) {
                        this.sslInitDone = true;
                        ctx.fireChannelActive();
                    } else {
                        Object connection = RedisConnection.getFrom(ctx.channel());
                        ((RedisConnection)connection).closeAsync();
                        ((RedisConnection)connection).getConnectionPromise().completeExceptionally(e.cause());
                    }
                }
                super.userEventTriggered(ctx, evt);
            }
        }});
    }

    public static enum Type {
        PUBSUB,
        PLAIN;

    }
}

