/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api.condition;

import java.util.ArrayList;
import java.util.Collection;
import org.redisson.api.condition.Condition;
import org.redisson.liveobject.condition.ANDCondition;
import org.redisson.liveobject.condition.EQCondition;
import org.redisson.liveobject.condition.GECondition;
import org.redisson.liveobject.condition.GTCondition;
import org.redisson.liveobject.condition.LECondition;
import org.redisson.liveobject.condition.LTCondition;
import org.redisson.liveobject.condition.ORCondition;

public final class Conditions {
    public static Condition in(String name, Object ... values) {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        for (Object value : values) {
            conditions.add(Conditions.eq(name, value));
        }
        return Conditions.or(conditions.toArray(new Condition[conditions.size()]));
    }

    public static Condition in(String name, Collection<?> values) {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        for (Object value : values) {
            conditions.add(Conditions.eq(name, value));
        }
        return Conditions.or(conditions.toArray(new Condition[conditions.size()]));
    }

    public static Condition eq(String name, Object value) {
        return new EQCondition(name, value);
    }

    public static Condition or(Condition ... conditions) {
        return new ORCondition(conditions);
    }

    public static Condition and(Condition ... conditions) {
        return new ANDCondition(conditions);
    }

    public static Condition gt(String name, Number value) {
        return new GTCondition(name, value);
    }

    public static Condition lt(String name, Number value) {
        return new LTCondition(name, value);
    }

    public static Condition ge(String name, Number value) {
        return new GECondition(name, value);
    }

    public static Condition le(String name, Number value) {
        return new LECondition(name, value);
    }

    private Conditions() {
    }
}

