/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api;

import org.redisson.api.map.MapLoader;
import org.redisson.api.map.MapLoaderAsync;
import org.redisson.api.map.MapWriter;
import org.redisson.api.map.MapWriterAsync;

public class MapOptions<K, V> {
    private MapLoader<K, V> loader;
    private MapWriter<K, V> writer;
    private MapWriterAsync<K, V> writerAsync;
    private MapLoaderAsync<K, V> loaderAsync;
    private WriteMode writeMode = WriteMode.WRITE_THROUGH;
    private int writeBehindBatchSize = 50;
    private int writeBehindDelay = 1000;

    protected MapOptions() {
    }

    protected MapOptions(MapOptions<K, V> copy) {
    }

    public static <K, V> MapOptions<K, V> defaults() {
        return new MapOptions<K, V>();
    }

    public MapOptions<K, V> writer(MapWriter<K, V> writer) {
        this.writer = writer;
        return this;
    }

    public MapWriter<K, V> getWriter() {
        return this.writer;
    }

    public MapOptions<K, V> writerAsync(MapWriterAsync<K, V> writer) {
        this.writerAsync = writer;
        return this;
    }

    public MapWriterAsync<K, V> getWriterAsync() {
        return this.writerAsync;
    }

    public MapOptions<K, V> writeBehindBatchSize(int writeBehindBatchSize) {
        this.writeBehindBatchSize = writeBehindBatchSize;
        return this;
    }

    public int getWriteBehindBatchSize() {
        return this.writeBehindBatchSize;
    }

    public MapOptions<K, V> writeBehindDelay(int writeBehindDelay) {
        this.writeBehindDelay = writeBehindDelay;
        return this;
    }

    public int getWriteBehindDelay() {
        return this.writeBehindDelay;
    }

    public MapOptions<K, V> writeMode(WriteMode writeMode) {
        this.writeMode = writeMode;
        return this;
    }

    public WriteMode getWriteMode() {
        return this.writeMode;
    }

    public MapOptions<K, V> loader(MapLoader<K, V> loader) {
        this.loader = loader;
        return this;
    }

    public MapLoader<K, V> getLoader() {
        return this.loader;
    }

    public MapOptions<K, V> loaderAsync(MapLoaderAsync<K, V> loaderAsync) {
        this.loaderAsync = loaderAsync;
        return this;
    }

    public MapLoaderAsync<K, V> getLoaderAsync() {
        return this.loaderAsync;
    }

    public static enum WriteMode {
        WRITE_BEHIND,
        WRITE_THROUGH;

    }
}

