/*
 * Decompiled with CFR 0.152.
 */
package org.perfrepo.model.to;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.perfrepo.model.Metric;
import org.perfrepo.model.Test;

public class MetricReportTO {

    @Deprecated
    public static class DataPoint
    implements Serializable,
    Comparable<DataPoint> {
        public static final Double CONFLICT = 1.0;
        public static final Double CONVERSION = 2.0;
        private Object param;
        private Double value;
        private Long execId;

        public DataPoint(Object param, Double value, Long execId) {
            this.param = param;
            this.value = value;
            this.execId = execId;
        }

        @Override
        public int compareTo(DataPoint o) {
            return ((Comparable)this.param).compareTo(o.param);
        }

        public String getParam() {
            return this.param.toString();
        }

        public Long getExecId() {
            return this.execId;
        }

        public String getProblemType() {
            if (CONFLICT.equals(this.value)) {
                return "Conflict";
            }
            if (CONVERSION.equals(this.value)) {
                return "Conversion";
            }
            return "N/A";
        }

        public String toString() {
            String problem = this.getProblemType();
            return "(" + this.param + ", " + ("N/A".equals(problem) ? this.value : "Problem: " + problem) + ", " + this.execId + ")";
        }

        public Double getValue() {
            return this.value;
        }
    }

    public static class ChartResponse
    implements Serializable {
        private List<Metric> selectionMetrics;
        private Test selectedTest;
        private List<SeriesResponse> series = new ArrayList<SeriesResponse>();
        private List<BaselineResponse> baselines = new ArrayList<BaselineResponse>();

        public void setSelectionMetrics(List<Metric> selectionMetric) {
            this.selectionMetrics = selectionMetric;
        }

        public Test getSelectedTest() {
            return this.selectedTest;
        }

        public void setSelectedTest(Test selectedTest) {
            this.selectedTest = selectedTest;
        }

        public List<SeriesResponse> getSeries() {
            return this.series;
        }

        public void setSeries(List<SeriesResponse> series) {
            this.series = series;
        }

        public List<Metric> getSelectionMetrics() {
            return this.selectionMetrics;
        }

        public void addSeries(SeriesResponse series) {
            this.series.add(series);
        }

        public List<BaselineResponse> getBaselines() {
            return this.baselines;
        }

        public void setBaselines(List<BaselineResponse> baselines) {
            this.baselines = baselines;
        }

        public void addBaseline(BaselineResponse baseline) {
            this.baselines.add(baseline);
        }
    }

    public static class Response
    implements Serializable {
        private List<Test> selectionTests;
        private List<ChartResponse> charts;

        public List<ChartResponse> getCharts() {
            return this.charts;
        }

        public void addChart(ChartResponse chart) {
            if (this.charts == null) {
                this.charts = new ArrayList<ChartResponse>();
            }
            this.charts.add(chart);
        }

        public List<Test> getSelectionTests() {
            return this.selectionTests;
        }

        public void setSelectionTests(List<Test> selectionTests) {
            this.selectionTests = selectionTests;
        }
    }

    public static class Request
    implements Serializable {
        public static final int DEFAULT_SIZE_LIMIT = 100;
        private List<ChartRequest> chartSpecs;
        private int limitSize = 100;

        public Request() {
        }

        public Request(List<ChartRequest> chartSpecs) {
            this.chartSpecs = chartSpecs;
        }

        public int getLimitSize() {
            return this.limitSize;
        }

        public void setLimitSize(int limitSize) {
            this.limitSize = limitSize;
        }

        public List<ChartRequest> getCharts() {
            return this.chartSpecs;
        }

        public void addChart(ChartRequest chart) {
            if (this.chartSpecs == null) {
                this.chartSpecs = new ArrayList<ChartRequest>();
            }
            this.chartSpecs.add(chart);
        }
    }

    public static class BaselineResponse
    implements Serializable {
        private String name;
        private Metric selectedMetric;
        private Long execId;
        private Double value;

        public BaselineResponse(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Metric getSelectedMetric() {
            return this.selectedMetric;
        }

        public void setSelectedMetric(Metric selectedMetric) {
            this.selectedMetric = selectedMetric;
        }

        public Long getExecId() {
            return this.execId;
        }

        public void setExecId(Long execId) {
            this.execId = execId;
        }

        public Double getValue() {
            return this.value;
        }

        public void setValue(Double value) {
            this.value = value;
        }
    }

    public static class SeriesResponse
    implements Serializable {
        private String name;
        private Metric selectedMetric;
        private List<DataPoint> datapoints;

        public SeriesResponse(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Metric getSelectedMetric() {
            return this.selectedMetric;
        }

        public void setSelectedMetric(Metric selectedMetric) {
            this.selectedMetric = selectedMetric;
        }

        public List<DataPoint> getDatapoints() {
            return this.datapoints;
        }

        public void setDatapoints(List<DataPoint> datapoints) {
            this.datapoints = datapoints;
        }
    }

    public static class BaselineRequest
    implements Serializable {
        private String name;
        private String metricName;
        private Long execId;

        public BaselineRequest(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getMetricName() {
            return this.metricName;
        }

        public void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public Long getExecId() {
            return this.execId;
        }

        public void setExecId(Long execId) {
            this.execId = execId;
        }

        public String toString() {
            return "(" + this.name + "|" + this.metricName + "|" + Long.toString(this.execId) + ")";
        }
    }

    public static class SeriesRequest
    implements Serializable {
        private String name;
        private String metricName;
        private List<String> tags;

        public SeriesRequest(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getMetricName() {
            return this.metricName;
        }

        public void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public void addTag(String tag) {
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            this.tags.add(tag);
        }

        public List<String> getTags() {
            return this.tags;
        }

        public void setTags(List<String> tags) {
            this.tags = tags;
        }

        public String toString() {
            return "(" + this.name + "|" + this.metricName + "|" + this.tags + ")";
        }
    }

    public static class ChartRequest
    implements Serializable {
        private String testUid;
        private List<SeriesRequest> series = new ArrayList<SeriesRequest>();
        private List<BaselineRequest> baselines = new ArrayList<BaselineRequest>();

        public String getTestUid() {
            return this.testUid;
        }

        public List<SeriesRequest> getSeries() {
            return this.series;
        }

        public void addSeries(SeriesRequest seriesToAdd) {
            this.series.add(seriesToAdd);
        }

        public void removeSeries(SeriesRequest seriesToRemove) {
            if (this.series != null) {
                this.series.remove(seriesToRemove);
            }
        }

        public void clearSeries() {
            this.series = null;
        }

        public List<BaselineRequest> getBaselines() {
            return this.baselines;
        }

        public void addBaseline(BaselineRequest baselineToAdd) {
            this.baselines.add(baselineToAdd);
        }

        public void removeBaselines(BaselineRequest baselineToRemove) {
            if (this.baselines != null) {
                this.baselines.remove(baselineToRemove);
            }
        }

        public void clearBaselines() {
            this.baselines = null;
        }

        public void setTestUid(String testUid) {
            this.testUid = testUid;
        }
    }
}

