/*
 * Decompiled with CFR 0.152.
 */
package org.perfrepo.model.report;

import java.util.Collection;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.perfrepo.model.Entity;
import org.perfrepo.model.auth.EntityType;
import org.perfrepo.model.auth.Permission;
import org.perfrepo.model.auth.SecuredEntity;
import org.perfrepo.model.report.ReportProperty;
import org.perfrepo.model.user.User;

@javax.persistence.Entity
@Table(name="report")
@SecuredEntity(type=EntityType.REPORT)
@XmlRootElement(name="report")
@NamedQueries(value={@NamedQuery(name="Report.findByUserName", query="SELECT distinct report from Report report join report.user user where user.username = :username"), @NamedQuery(name="Report.getByGroupPermission", query="SELECT distinct report from Report report join report.permissions perm where perm.groupId in (:groupIds) or perm.userId= :userId"), @NamedQuery(name="Report.getByAnyPermission", query="SELECT distinct report from Report report join report.permissions perm where perm.level = 'PUBLIC' or perm.groupId in (:groupIds) or perm.userId= :userId"), @NamedQuery(name="Report.findMaxId", query="SELECT max(report.id) from Report report")})
public class Report
implements Entity<Report>,
Comparable<Report> {
    private static final long serialVersionUID = -2188625358440509257L;
    public static final String GET_BY_USERNAME = "Report.findByUserName";
    public static final String GET_BY_GROUP_PERMISSION = "Report.getByGroupPermission";
    public static final String GET_BY_ANY_PERMISSION = "Report.getByAnyPermission";
    public static final String FIND_MAX_ID = "Report.findMaxId";
    @Id
    @SequenceGenerator(name="REPORT_ID_GENERATOR", sequenceName="REPORT_SEQUENCE", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="REPORT_ID_GENERATOR")
    private Long id;
    @Column(name="name")
    @NotNull
    @Size(max=255)
    private String name;
    @Column(name="type")
    @NotNull
    @Size(max=255)
    private String type;
    @ManyToOne(optional=false, cascade={CascadeType.MERGE})
    @JoinColumn(name="user_id", referencedColumnName="id")
    @NotNull
    private User user;
    @OneToMany(mappedBy="report", cascade={CascadeType.ALL}, orphanRemoval=true)
    @MapKey(name="name")
    private Map<String, ReportProperty> properties;
    @OneToMany(mappedBy="report")
    private Collection<Permission> permissions;
    @Transient
    private String username;

    public Report() {
    }

    public Report(Long id) {
        this.id = id;
    }

    @Override
    @XmlAttribute(name="id")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @XmlAttribute(name="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlAttribute(name="type")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @XmlTransient
    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    @XmlElementWrapper(name="properties")
    @XmlElement(name="property")
    public Map<String, ReportProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, ReportProperty> properties) {
        this.properties = properties;
    }

    @XmlElementWrapper(name="permissions")
    @XmlElement(name="permission")
    public Collection<Permission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Collection<Permission> permissions) {
        this.permissions = permissions;
    }

    @XmlAttribute(name="user")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Report other = (Report)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.user == null ? other.user != null : !this.user.equals(other.user));
    }

    @Override
    public Report clone() {
        try {
            return (Report)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int compareTo(Report o) {
        return this.getName().compareTo(o.getName());
    }
}

