/*
 * Decompiled with CFR 0.152.
 */
package org.perfrepo.model.builder;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.perfrepo.model.Metric;
import org.perfrepo.model.Value;
import org.perfrepo.model.ValueParameter;
import org.perfrepo.model.builder.TestExecutionBuilder;

public class ValueBuilder {
    private TestExecutionBuilder parentBuilder;
    private Value value;

    ValueBuilder(TestExecutionBuilder parentBuilder, Value value) {
        this.parentBuilder = parentBuilder;
        this.value = value;
    }

    private ValueParameter addParameter(ValueParameter param) {
        Collection<ValueParameter> parameters = this.value.getParameters();
        if (parameters == null) {
            parameters = new HashSet<ValueParameter>();
            this.value.setParameters((Set)parameters);
        }
        parameters.add(param);
        return param;
    }

    public ValueBuilder parameter(String name, String value) {
        this.addParameter(new ValueParameter(name, value));
        return this;
    }

    public ValueBuilder metricName(String metricName) {
        Metric metric = this.value.getMetric();
        if (metric == null) {
            metric = new Metric();
            this.value.setMetric(metric);
        }
        metric.setName(metricName);
        return this;
    }

    public ValueBuilder resultValue(Double resultValue) {
        this.value.setResultValue(resultValue);
        return this;
    }

    public TestExecutionBuilder execution() {
        return this.parentBuilder;
    }
}

