/*
 * Decompiled with CFR 0.152.
 */
package org.perfrepo.model.builder;

import java.util.ArrayList;
import java.util.Collection;
import org.perfrepo.model.Metric;
import org.perfrepo.model.MetricComparator;
import org.perfrepo.model.Test;
import org.perfrepo.model.builder.MetricBuilder;

public class TestBuilder {
    private Test test = new Test();

    public TestBuilder name(String name) {
        this.test.setName(name);
        return this;
    }

    public TestBuilder description(String description) {
        this.test.setDescription(description);
        return this;
    }

    public TestBuilder groupId(String groupId) {
        this.test.setGroupId(groupId);
        return this;
    }

    public TestBuilder uid(String uid) {
        this.test.setUid(uid);
        return this;
    }

    public Test build() {
        return this.test.clone();
    }

    public TestBuilder metric(String name, MetricComparator comparator, String description) {
        return this.metric().name(name).comparator(comparator).description(description).test();
    }

    public TestBuilder metric(String name, String description) {
        return this.metric().name(name).description(description).comparator(MetricComparator.HB).test();
    }

    public TestBuilder metric(String name) {
        return this.metric().name(name).test();
    }

    public MetricBuilder metric() {
        return new MetricBuilder(this, this.addMetric(new Metric()));
    }

    private Metric addMetric(Metric metric) {
        Collection<Test> tests;
        Collection<Metric> metrics = this.test.getMetrics();
        if (metrics == null) {
            this.test.setMetrics(new ArrayList<Metric>());
        }
        if ((tests = metric.getTests()) == null) {
            metric.setTests(new ArrayList<Test>());
        }
        metric.getTests().add(this.test);
        this.test.getMetrics().add(metric);
        return metric;
    }
}

