/*
 * Decompiled with CFR 0.152.
 */
package org.perfrepo.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.perfrepo.model.Alert;
import org.perfrepo.model.Entity;
import org.perfrepo.model.Metric;
import org.perfrepo.model.TestExecution;
import org.perfrepo.model.auth.EntityType;
import org.perfrepo.model.auth.SecuredEntity;
import org.perfrepo.model.builder.TestBuilder;
import org.perfrepo.model.user.User;

@javax.persistence.Entity
@Table(name="test")
@SecuredEntity(type=EntityType.TEST)
@NamedQueries(value={@NamedQuery(name="Test.findByUid", query="SELECT test FROM Test test WHERE test.uid = :uid")})
@XmlRootElement(name="test")
public class Test
implements Entity<Test> {
    private static final long serialVersionUID = 2936849220074718535L;
    public static final String FIND_BY_UID = "Test.findByUid";
    @Id
    @SequenceGenerator(name="TEST_ID_GENERATOR", sequenceName="TEST_SEQUENCE", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="TEST_ID_GENERATOR")
    private Long id;
    @Column(name="name")
    @NotNull(message="{page.test.nameRequired}")
    @Size(max=2047)
    private String name;
    @OneToMany(mappedBy="test")
    private Collection<TestExecution> testExecutions;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="test_metric", joinColumns={@JoinColumn(name="test_id", nullable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="metric_id", nullable=false, updatable=false)})
    private Collection<Metric> metrics;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="test_subscriber", joinColumns={@JoinColumn(name="test_id", nullable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="user_id", nullable=false, updatable=false)})
    private Collection<User> subscribers;
    @OneToMany(mappedBy="test")
    private Collection<Alert> alerts;
    @Column(name="uid")
    @NotNull(message="{page.test.uidRequired}")
    @Size(max=2047)
    private String uid;
    @Column(name="groupId")
    @NotNull(message="{page.test.groupRequired}")
    @Size(max=255)
    private String groupId;
    @Column(name="description")
    @Size(max=10239)
    private String description;

    @Override
    @XmlTransient
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @XmlID
    @XmlAttribute(name="id")
    public String getStringId() {
        return this.id == null ? null : String.valueOf(this.id);
    }

    public void setStringId(String id) {
        this.id = Long.valueOf(id);
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlAttribute(name="name")
    public String getName() {
        return this.name;
    }

    public void setTestExecutions(Collection<TestExecution> testExecutions) {
        this.testExecutions = testExecutions;
    }

    @XmlTransient
    public Collection<TestExecution> getTestExecutions() {
        return this.testExecutions;
    }

    @XmlTransient
    public Collection<User> getSubscribers() {
        return this.subscribers;
    }

    public void setSubscribers(Collection<User> testSubscribers) {
        this.subscribers = testSubscribers;
    }

    @XmlTransient
    public Collection<Alert> getAlerts() {
        return this.alerts;
    }

    public void setAlerts(Collection<Alert> alerts) {
        this.alerts = alerts;
    }

    @XmlElementWrapper(name="metrics")
    @XmlElement(name="metric")
    public Collection<Metric> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(Collection<Metric> metrics) {
        this.metrics = metrics;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    @XmlAttribute(name="uid")
    public String getUid() {
        return this.uid;
    }

    @XmlAttribute(name="groupId")
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @XmlElement(name="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @XmlTransient
    public List<Metric> getSortedMetrics() {
        Collection<Metric> tags = this.getMetrics();
        if (tags == null) {
            return new ArrayList<Metric>();
        }
        return tags.stream().sorted((o1, o2) -> o1.compareTo((Metric)o2)).collect(Collectors.toList());
    }

    public static TestBuilder builder() {
        return new TestBuilder();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.uid == null ? 0 : this.uid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Test other = (Test)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.uid == null ? other.uid != null : !this.uid.equals(other.uid));
    }

    @Override
    public Test clone() {
        try {
            return (Test)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

