/*
 * Decompiled with CFR 0.152.
 */
package org.perfrepo.model;

import java.util.Collection;
import javax.persistence.Column;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.perfrepo.model.Alert;
import org.perfrepo.model.Entity;
import org.perfrepo.model.MetricComparator;
import org.perfrepo.model.Test;
import org.perfrepo.model.Value;
import org.perfrepo.model.builder.MetricBuilder;

@javax.persistence.Entity
@Table(name="metric")
@NamedQueries(value={@NamedQuery(name="Metric.getTest", query="SELECT m.tests from Metric m where m= :entity"), @NamedQuery(name="Metric.findByNameGroupId", query="SELECT m from Metric m inner join m.tests test where test.groupId= :groupId and m.name= :name"), @NamedQuery(name="Metric.findByGroupId", query="SELECT DISTINCT m from Metric m inner join m.tests t WHERE t.groupId= :groupId ORDER BY m.name")})
@XmlRootElement(name="metric")
public class Metric
implements Entity<Metric>,
Comparable<Metric> {
    private static final long serialVersionUID = -5234628391341278215L;
    public static final String GET_TEST = "Metric.getTest";
    public static final String FIND_BY_NAME_GROUPID = "Metric.findByNameGroupId";
    public static final String FIND_BY_GROUPID = "Metric.findByGroupId";
    @Id
    @SequenceGenerator(name="METRIC_ID_GENERATOR", sequenceName="METRIC_SEQUENCE", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="METRIC_ID_GENERATOR")
    private Long id;
    @Column(name="comparator")
    @NotNull(message="{page.metric.comparatorRequired}")
    @Enumerated(value=EnumType.STRING)
    private MetricComparator comparator;
    @Column(name="name")
    @NotNull(message="{page.metric.nameRequired}")
    @Size(max=2047)
    private String name;
    @OneToMany(mappedBy="metric")
    private Collection<Value> values;
    @ManyToMany(mappedBy="metrics")
    private Collection<Test> tests;
    @OneToMany(mappedBy="metric")
    private Collection<Alert> alerts;
    @Column(name="description")
    @Size(max=10239)
    private String description;

    public Metric() {
    }

    @Override
    public Metric clone() {
        try {
            return (Metric)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public Metric(String name, MetricComparator comparator, String description) {
        this.name = name;
        this.comparator = comparator;
        this.description = description;
    }

    @Override
    @XmlTransient
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @XmlID
    @XmlAttribute(name="id")
    public String getStringId() {
        return this.id == null ? null : String.valueOf(this.id);
    }

    @XmlTransient
    public Collection<Alert> getAlerts() {
        return this.alerts;
    }

    public void setAlerts(Collection<Alert> alerts) {
        this.alerts = alerts;
    }

    public void setStringId(String id) {
        this.id = Long.valueOf(id);
    }

    public void setComparator(MetricComparator comparator) {
        this.comparator = comparator;
    }

    @XmlAttribute(name="comparator")
    public MetricComparator getComparator() {
        return this.comparator;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlAttribute(name="name")
    public String getName() {
        return this.name;
    }

    public void setValues(Collection<Value> values) {
        this.values = values;
    }

    @XmlTransient
    public Collection<Value> getValues() {
        return this.values;
    }

    @XmlElement(name="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setTests(Collection<Test> tests) {
        this.tests = tests;
    }

    @Override
    public int compareTo(Metric o) {
        return this.getName().compareTo(o.getName());
    }

    @XmlTransient
    public Collection<Test> getTests() {
        return this.tests;
    }

    public static MetricBuilder builder() {
        return new MetricBuilder(null, new Metric());
    }
}

