/*
 * Decompiled with CFR 0.152.
 */
package org.perfrepo.client;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.List;
import javax.xml.bind.DataBindingException;
import javax.xml.bind.JAXB;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.perfrepo.model.Metric;
import org.perfrepo.model.Test;
import org.perfrepo.model.TestExecution;
import org.perfrepo.model.Value;
import org.perfrepo.model.auth.Permission;
import org.perfrepo.model.report.Report;
import org.perfrepo.model.to.ListWrapper;
import org.perfrepo.model.to.TestExecutionSearchTO;

public class PerfRepoClient {
    private static final Logger log = Logger.getLogger(PerfRepoClient.class);
    private static final String CONTENT_TYPE_XML = "text/xml";
    private static final String REST_BASE_URL_TEMPLATE = "http://%s%s/rest/";
    private String host;
    private String url;
    private String basicAuthHash;
    private HttpClient httpClient;

    public PerfRepoClient(String host, String url, String username, String password) {
        this.host = host;
        this.url = url;
        if (this.url != null && !url.isEmpty()) {
            this.url = "/" + this.url;
        }
        this.basicAuthHash = Base64.encodeBase64String((byte[])(username + ":" + password).getBytes()).trim();
        this.httpClient = new DefaultHttpClient();
    }

    @Deprecated
    public PerfRepoClient(String host, String url, String basicAuthHash) {
        this.host = host;
        this.url = url;
        if (this.url != null && !url.isEmpty()) {
            this.url = "/" + this.url;
        }
        this.basicAuthHash = basicAuthHash;
        this.httpClient = new DefaultHttpClient();
    }

    public void shutdown() {
        this.httpClient.getConnectionManager().shutdown();
    }

    private String restUrl(String urlTemplate, Object ... params) {
        return String.format(String.format(REST_BASE_URL_TEMPLATE, this.host, this.url == null ? "" : this.url) + urlTemplate, params);
    }

    private void logHttpError(String msg, HttpRequestBase req, HttpResponse resp) throws Exception {
        log.error((Object)(msg + "\nHTTP Status: " + resp.getStatusLine().getStatusCode() + "\nREST API url: " + req.getURI().toString() + "\nResponse:\n" + EntityUtils.toString((HttpEntity)resp.getEntity())));
    }

    private HttpPost createBasicPost(String relURL, Object ... params) {
        HttpPost post = new HttpPost(this.restUrl(relURL, params));
        post.setHeader("Content-Type", CONTENT_TYPE_XML);
        post.setHeader("Authorization", "Basic " + this.basicAuthHash);
        return post;
    }

    private HttpGet createBasicGet(String relURL, Object ... params) {
        HttpGet get = new HttpGet(this.restUrl(relURL, params));
        get.setHeader("Authorization", "Basic " + this.basicAuthHash);
        return get;
    }

    private HttpDelete createBasicDelete(String relURL, Object ... params) {
        HttpDelete delete = new HttpDelete(this.restUrl(relURL, params));
        delete.setHeader("Authorization", "Basic " + this.basicAuthHash);
        return delete;
    }

    private void setPostEntity(HttpPost req, Object obj) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        JAXB.marshal((Object)obj, (OutputStream)bos);
        req.setEntity((HttpEntity)new ByteArrayEntity(bos.toByteArray()));
    }

    public Long createTest(Test test) throws Exception {
        HttpPost post = this.createBasicPost("test/create", new Object[0]);
        this.setPostEntity(post, test);
        HttpResponse resp = this.httpClient.execute((HttpUriRequest)post);
        if (resp.getStatusLine().getStatusCode() != 201) {
            this.logHttpError("Error while creating test", (HttpRequestBase)post, resp);
            EntityUtils.consume((HttpEntity)resp.getEntity());
            return null;
        }
        Header[] locations = resp.getHeaders("Location");
        if (locations != null && locations.length > 0) {
            log.debug((Object)("Created new test at: " + locations[0].getValue()));
        }
        Long id = new Long(EntityUtils.toString((HttpEntity)resp.getEntity()));
        EntityUtils.consume((HttpEntity)resp.getEntity());
        return id;
    }

    public Long addValue(TestExecution te) throws Exception {
        HttpPost post = this.createBasicPost("testExecution/addValue", new Object[0]);
        this.setPostEntity(post, te);
        HttpResponse resp = this.httpClient.execute((HttpUriRequest)post);
        if (resp.getStatusLine().getStatusCode() != 201) {
            this.logHttpError("Error while creating value", (HttpRequestBase)post, resp);
            EntityUtils.consume((HttpEntity)resp.getEntity());
            return null;
        }
        Header[] locations = resp.getHeaders("Location");
        if (locations != null && locations.length > 0) {
            log.debug((Object)("Added new value at: " + locations[0].getValue()));
        }
        Long id = new Long(EntityUtils.toString((HttpEntity)resp.getEntity()));
        EntityUtils.consume((HttpEntity)resp.getEntity());
        return id;
    }

    public Test getTest(Long id) throws Exception {
        HttpGet get = this.createBasicGet("test/id/%s", id);
        HttpResponse resp = this.httpClient.execute((HttpUriRequest)get);
        if (resp.getStatusLine().getStatusCode() == 200) {
            Test obj;
            try {
                obj = (Test)JAXB.unmarshal((InputStream)resp.getEntity().getContent(), Test.class);
            }
            catch (DataBindingException ex) {
                log.warn((Object)"Error occurred while unmarshalling response, probably empty response.");
                return null;
            }
            EntityUtils.consume((HttpEntity)resp.getEntity());
            return obj;
        }
        if (resp.getStatusLine().getStatusCode() == 404) {
            EntityUtils.consume((HttpEntity)resp.getEntity());
            return null;
        }
        this.logHttpError("Error while getting test", (HttpRequestBase)get, resp);
        EntityUtils.consume((HttpEntity)resp.getEntity());
        return null;
    }

    public Test getTestByUid(String uid) throws Exception {
        HttpGet get = this.createBasicGet("test/uid/%s", uid);
        HttpResponse resp = this.httpClient.execute((HttpUriRequest)get);
        if (resp.getStatusLine().getStatusCode() == 200) {
            Test obj;
            try {
                obj = (Test)JAXB.unmarshal((InputStream)resp.getEntity().getContent(), Test.class);
            }
            catch (DataBindingException ex) {
                log.warn((Object)"Error occurred while unmarshalling response, probably empty response.");
                return null;
            }
            EntityUtils.consume((HttpEntity)resp.getEntity());
            return obj;
        }
        if (resp.getStatusLine().getStatusCode() == 404) {
            EntityUtils.consume((HttpEntity)resp.getEntity());
            return null;
        }
        this.logHttpError("Error while getting test", (HttpRequestBase)get, resp);
        EntityUtils.consume((HttpEntity)resp.getEntity());
        return null;
    }

    public boolean deleteTest(Long id) throws Exception {
        HttpDelete delete = this.createBasicDelete("test/id/%s", id);
        HttpResponse resp = this.httpClient.execute((HttpUriRequest)delete);
        if (resp.getStatusLine().getStatusCode() == 204) {
            EntityUtils.consume((HttpEntity)resp.getEntity());
            log.debug((Object)("Deleted test: " + id));
            return true;
        }
        this.logHttpError("Error while deleting test", (HttpRequestBase)delete, resp);
        EntityUtils.consume((HttpEntity)resp.getEntity());
        return false;
    }

    public Long createTestExecution(TestExecution testExecution) throws Exception {
        HttpPost post = this.createBasicPost("testExecution/create", new Object[0]);
        this.setPostEntity(post, testExecution);
        HttpResponse resp = this.httpClient.execute((HttpUriRequest)post);
        if (resp.getStatusLine().getStatusCode() != 201) {
            this.logHttpError("Error while creating test execution", (HttpRequestBase)post, resp);
            EntityUtils.consume((HttpEntity)resp.getEntity());
            return null;
        }
        Header[] locations = resp.getHeaders("Location");
        if (locations != null && locations.length > 0) {
            log.debug((Object)("Created new test execution at: " + locations[0].getValue()));
        }
        Long id = new Long(EntityUtils.toString((HttpEntity)resp.getEntity()));
        EntityUtils.consume((HttpEntity)resp.getEntity());
        return id;
    }

    public List<TestExecution> searchTestExecutions(TestExecutionSearchTO criteria) throws Exception {
        Object result = null;
        HttpPost post = this.createBasicPost("testExecution/search", new Object[0]);
        this.setPostEntity(post, criteria);
        HttpResponse resp = this.httpClient.execute((HttpUriRequest)post);
        if (resp.getStatusLine().getStatusCode() == 200) {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ListWrapper.class, TestExecution.class, Value.class});
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            ListWrapper obj = (ListWrapper)unmarshaller.unmarshal((Source)new StreamSource(resp.getEntity().getContent()), ListWrapper.class).getValue();
            EntityUtils.consume((HttpEntity)resp.getEntity());
            return obj.getItems();
        }
        this.logHttpError("Error while searching for test executions", (HttpRequestBase)post, resp);
        EntityUtils.consume((HttpEntity)resp.getEntity());
        return null;
    }

    public Long updateTestExecution(TestExecution testExecution) throws Exception {
        if (testExecution == null || testExecution.getId() == null) {
            throw new IllegalArgumentException("Neither test execution nor test execution ID can be null.");
        }
        HttpPost post = this.createBasicPost("testExecution/update/%s", testExecution.getId());
        this.setPostEntity(post, testExecution);
        HttpResponse resp = this.httpClient.execute((HttpUriRequest)post);
        if (resp.getStatusLine().getStatusCode() != 201) {
            this.logHttpError("Error while updating test execution.", (HttpRequestBase)post, resp);
            EntityUtils.consume((HttpEntity)resp.getEntity());
            return null;
        }
        Header[] locations = resp.getHeaders("Location");
        if (locations != null && locations.length > 0) {
            log.debug((Object)("Updated test execution at: " + locations[0].getValue()));
        }
        Long id = new Long(EntityUtils.toString((HttpEntity)resp.getEntity()));
        EntityUtils.consume((HttpEntity)resp.getEntity());
        return id;
    }

    public TestExecution getTestExecution(Long id) throws Exception {
        HttpGet get = this.createBasicGet("testExecution/%s", id);
        HttpResponse resp = this.httpClient.execute((HttpUriRequest)get);
        if (resp.getStatusLine().getStatusCode() == 200) {
            TestExecution obj;
            try {
                obj = (TestExecution)JAXB.unmarshal((InputStream)resp.getEntity().getContent(), TestExecution.class);
            }
            catch (DataBindingException ex) {
                log.warn((Object)"Error occurred while unmarshalling response, probably empty response.");
                return null;
            }
            EntityUtils.consume((HttpEntity)resp.getEntity());
            return obj;
        }
        if (resp.getStatusLine().getStatusCode() == 404) {
            EntityUtils.consume((HttpEntity)resp.getEntity());
            return null;
        }
        this.logHttpError("Error while getting test execution", (HttpRequestBase)get, resp);
        EntityUtils.consume((HttpEntity)resp.getEntity());
        return null;
    }

    public boolean deleteTestExecution(Long id) throws Exception {
        HttpDelete req = this.createBasicDelete("testExecution/%s", id);
        HttpResponse resp = this.httpClient.execute((HttpUriRequest)req);
        if (resp.getStatusLine().getStatusCode() == 204) {
            EntityUtils.consume((HttpEntity)resp.getEntity());
            log.debug((Object)("Deleted test execution: " + id));
            return true;
        }
        this.logHttpError("Error while deleting test execution", (HttpRequestBase)req, resp);
        EntityUtils.consume((HttpEntity)resp.getEntity());
        return false;
    }

    public Long addMetric(Long testId, Metric metric) throws Exception {
        HttpPost post = this.createBasicPost("test/id/%s/addMetric", testId);
        this.setPostEntity(post, metric);
        HttpResponse resp = this.httpClient.execute((HttpUriRequest)post);
        if (resp.getStatusLine().getStatusCode() != 201) {
            this.logHttpError("Error while adding metric", (HttpRequestBase)post, resp);
            EntityUtils.consume((HttpEntity)resp.getEntity());
            return null;
        }
        Header[] locations = resp.getHeaders("Location");
        if (locations != null && locations.length > 0) {
            log.debug((Object)("Created new metric at: " + locations[0].getValue()));
        }
        Long id = new Long(EntityUtils.toString((HttpEntity)resp.getEntity()));
        EntityUtils.consume((HttpEntity)resp.getEntity());
        return id;
    }

    public Metric getMetric(Long id) throws Exception {
        HttpGet get = this.createBasicGet("metric/%s", id);
        HttpResponse resp = this.httpClient.execute((HttpUriRequest)get);
        if (resp.getStatusLine().getStatusCode() == 200) {
            Metric metric = (Metric)JAXB.unmarshal((InputStream)resp.getEntity().getContent(), Metric.class);
            EntityUtils.consume((HttpEntity)resp.getEntity());
            return metric;
        }
        if (resp.getStatusLine().getStatusCode() == 404) {
            EntityUtils.consume((HttpEntity)resp.getEntity());
            return null;
        }
        this.logHttpError("Error while getting metric", (HttpRequestBase)get, resp);
        EntityUtils.consume((HttpEntity)resp.getEntity());
        return null;
    }

    public Long uploadAttachment(Long testExecutionId, File file, String mimeType, String fileNameInRepo) throws Exception {
        InputStreamEntity entity = new InputStreamEntity((InputStream)new FileInputStream(file), file.length());
        return this.uploadAttachment(testExecutionId, (AbstractHttpEntity)entity, mimeType, fileNameInRepo);
    }

    public Long uploadAttachment(Long testExecutionId, byte[] content, String mimeType, String fileNameInRepo) throws Exception {
        return this.uploadAttachment(testExecutionId, (AbstractHttpEntity)new ByteArrayEntity(content), mimeType, fileNameInRepo);
    }

    private Long uploadAttachment(Long testExecutionId, AbstractHttpEntity entity, String mimeType, String fileNameInRepo) throws Exception {
        HttpPost post = new HttpPost(this.restUrl("testExecution/%s/addAttachment", testExecutionId));
        post.setHeader("Content-Type", mimeType);
        post.setHeader("Authorization", "Basic " + this.basicAuthHash);
        post.setHeader("filename", fileNameInRepo);
        post.setEntity((HttpEntity)entity);
        HttpResponse resp = this.httpClient.execute((HttpUriRequest)post);
        if (resp.getStatusLine().getStatusCode() != 201) {
            this.logHttpError("Error while uploading attachment", (HttpRequestBase)post, resp);
            EntityUtils.consume((HttpEntity)resp.getEntity());
            return null;
        }
        Header[] locations = resp.getHeaders("Location");
        if (locations != null && locations.length > 0) {
            log.debug((Object)("Uploaded attachment: " + locations[0].getValue()));
        }
        Long id = new Long(EntityUtils.toString((HttpEntity)resp.getEntity()));
        EntityUtils.consume((HttpEntity)resp.getEntity());
        return id;
    }

    public boolean downloadAttachment(Long attachmentId, File file) throws Exception {
        HttpGet get = this.createBasicGet("testExecution/attachment/%s", attachmentId);
        HttpResponse resp = this.httpClient.execute((HttpUriRequest)get);
        if (resp.getStatusLine().getStatusCode() == 200) {
            resp.getEntity().writeTo((OutputStream)new FileOutputStream(file));
            EntityUtils.consume((HttpEntity)resp.getEntity());
            return true;
        }
        if (resp.getStatusLine().getStatusCode() == 404) {
            EntityUtils.consume((HttpEntity)resp.getEntity());
            return false;
        }
        this.logHttpError("Error while downloading attachment", (HttpRequestBase)get, resp);
        EntityUtils.consume((HttpEntity)resp.getEntity());
        return false;
    }

    public Report getReport(Long id) throws Exception {
        HttpGet get = this.createBasicGet("report/id/%s", id);
        HttpResponse resp = this.httpClient.execute((HttpUriRequest)get);
        if (resp.getStatusLine().getStatusCode() == 200) {
            Report obj;
            try {
                obj = (Report)JAXB.unmarshal((InputStream)resp.getEntity().getContent(), Report.class);
            }
            catch (DataBindingException ex) {
                log.warn((Object)"Error occurred while unmarshalling response, probably empty response.");
                return null;
            }
            EntityUtils.consume((HttpEntity)resp.getEntity());
            return obj;
        }
        if (resp.getStatusLine().getStatusCode() == 404) {
            EntityUtils.consume((HttpEntity)resp.getEntity());
            return null;
        }
        this.logHttpError("Error while getting report.", (HttpRequestBase)get, resp);
        EntityUtils.consume((HttpEntity)resp.getEntity());
        return null;
    }

    public Long createReport(Report report) throws Exception {
        HttpPost post = this.createBasicPost("report/create", new Object[0]);
        this.setPostEntity(post, report);
        HttpResponse resp = this.httpClient.execute((HttpUriRequest)post);
        if (resp.getStatusLine().getStatusCode() != 201) {
            this.logHttpError("Error while creating report.", (HttpRequestBase)post, resp);
            EntityUtils.consume((HttpEntity)resp.getEntity());
            return null;
        }
        Header[] locations = resp.getHeaders("Location");
        if (locations != null && locations.length > 0) {
            log.debug((Object)("Created new report at: " + locations[0].getValue()));
        }
        Long id = new Long(EntityUtils.toString((HttpEntity)resp.getEntity()));
        EntityUtils.consume((HttpEntity)resp.getEntity());
        return id;
    }

    public Long updateReport(Report report) throws Exception {
        if (report == null || report.getId() == null) {
            throw new IllegalArgumentException("Neither report nor report ID can be null.");
        }
        HttpPost post = this.createBasicPost("report/update/%s", report.getId());
        this.setPostEntity(post, report);
        HttpResponse resp = this.httpClient.execute((HttpUriRequest)post);
        if (resp.getStatusLine().getStatusCode() != 201) {
            this.logHttpError("Error while updating report.", (HttpRequestBase)post, resp);
            EntityUtils.consume((HttpEntity)resp.getEntity());
            return null;
        }
        Header[] locations = resp.getHeaders("Location");
        if (locations != null && locations.length > 0) {
            log.debug((Object)("Updated report at: " + locations[0].getValue()));
        }
        Long id = new Long(EntityUtils.toString((HttpEntity)resp.getEntity()));
        EntityUtils.consume((HttpEntity)resp.getEntity());
        return id;
    }

    public boolean deleteReport(Long id) throws Exception {
        HttpDelete delete = this.createBasicDelete("report/id/%s", id);
        HttpResponse resp = this.httpClient.execute((HttpUriRequest)delete);
        if (resp.getStatusLine().getStatusCode() == 204) {
            EntityUtils.consume((HttpEntity)resp.getEntity());
            log.debug((Object)("Deleted report: " + id));
            return true;
        }
        this.logHttpError("Error while deleting report", (HttpRequestBase)delete, resp);
        EntityUtils.consume((HttpEntity)resp.getEntity());
        return false;
    }

    public boolean addReportPermission(Permission permission) throws Exception {
        if (permission == null || permission.getReportId() == null) {
            throw new IllegalArgumentException("Permission or its report ID cannot be null.");
        }
        HttpPost post = this.createBasicPost("report/id/" + permission.getReportId() + "/addPermission", new Object[0]);
        this.setPostEntity(post, permission);
        HttpResponse resp = this.httpClient.execute((HttpUriRequest)post);
        if (resp.getStatusLine().getStatusCode() != 200) {
            this.logHttpError("Error while adding permission", (HttpRequestBase)post, resp);
            EntityUtils.consume((HttpEntity)resp.getEntity());
            return false;
        }
        Header[] locations = resp.getHeaders("Location");
        if (locations != null && locations.length > 0) {
            log.debug((Object)("Added new permission at: " + locations[0].getValue()));
        }
        EntityUtils.consume((HttpEntity)resp.getEntity());
        return true;
    }

    public boolean updateReportPermission(Permission permission) throws Exception {
        if (permission == null || permission.getReportId() == null) {
            throw new IllegalArgumentException("Permission or its report ID cannot be null.");
        }
        HttpPost post = this.createBasicPost("report/id/" + permission.getReportId() + "/updatePermission", new Object[0]);
        this.setPostEntity(post, permission);
        HttpResponse resp = this.httpClient.execute((HttpUriRequest)post);
        if (resp.getStatusLine().getStatusCode() != 200) {
            this.logHttpError("Error while updating permission", (HttpRequestBase)post, resp);
            EntityUtils.consume((HttpEntity)resp.getEntity());
            return false;
        }
        Header[] locations = resp.getHeaders("Location");
        if (locations != null && locations.length > 0) {
            log.debug((Object)("Updated permission at: " + locations[0].getValue()));
        }
        EntityUtils.consume((HttpEntity)resp.getEntity());
        return true;
    }

    public boolean deleteReportPermission(Permission permission) throws Exception {
        if (permission == null || permission.getReportId() == null) {
            throw new IllegalArgumentException("Permission or its report ID cannot be null.");
        }
        HttpPost post = this.createBasicPost("report/id/" + permission.getReportId() + "/deletePermission", new Object[0]);
        this.setPostEntity(post, permission);
        HttpResponse resp = this.httpClient.execute((HttpUriRequest)post);
        if (resp.getStatusLine().getStatusCode() != 200) {
            this.logHttpError("Error while deleting permission", (HttpRequestBase)post, resp);
            EntityUtils.consume((HttpEntity)resp.getEntity());
            return false;
        }
        Header[] locations = resp.getHeaders("Location");
        if (locations != null && locations.length > 0) {
            log.debug((Object)("Deleted permission at: " + locations[0].getValue()));
        }
        EntityUtils.consume((HttpEntity)resp.getEntity());
        return true;
    }

    public String getServerVersion() throws Exception {
        HttpGet get = this.createBasicGet("info/version", new Object[0]);
        HttpResponse resp = this.httpClient.execute((HttpUriRequest)get);
        BufferedReader reader = new BufferedReader(new InputStreamReader(resp.getEntity().getContent()));
        return reader.readLine();
    }
}

