/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.springframework.annotation;

import java.util.List;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.pac4j.core.authorization.authorizer.IsAuthenticatedAuthorizer;
import org.pac4j.core.authorization.authorizer.RequireAllRolesAuthorizer;
import org.pac4j.core.authorization.authorizer.RequireAnyRoleAuthorizer;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.exception.http.ForbiddenAction;
import org.pac4j.core.exception.http.UnauthorizedAction;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.springframework.annotation.RequireAllRoles;
import org.pac4j.springframework.annotation.RequireAnyRole;
import org.springframework.beans.factory.annotation.Autowired;

@Aspect
public class RequireRoleAnnotationAspect {
    private static final IsAuthenticatedAuthorizer IS_AUTHENTICATED_AUTHORIZER = new IsAuthenticatedAuthorizer();
    @Autowired
    private JEEContext webContext;
    @Autowired
    private SessionStore sessionStore;
    @Autowired
    private ProfileManager profileManager;

    protected List<UserProfile> isAuthenticated() {
        List profiles = this.profileManager.getProfiles();
        if (!IS_AUTHENTICATED_AUTHORIZER.isAuthorized((WebContext)this.webContext, this.sessionStore, profiles)) {
            throw UnauthorizedAction.INSTANCE;
        }
        return profiles;
    }

    @Before(value="@annotation(requireAnyRole)")
    public void beforeRequireAnyRole(RequireAnyRole requireAnyRole) {
        List<UserProfile> profiles = this.isAuthenticated();
        RequireAnyRoleAuthorizer authorizer = new RequireAnyRoleAuthorizer(requireAnyRole.value());
        if (!authorizer.isAuthorized((WebContext)this.webContext, this.sessionStore, profiles)) {
            throw ForbiddenAction.INSTANCE;
        }
    }

    @Before(value="@annotation(requireAllRoles)")
    public void beforeRequireAllRoles(RequireAllRoles requireAllRoles) {
        List<UserProfile> profiles = this.isAuthenticated();
        RequireAllRolesAuthorizer authorizer = new RequireAllRolesAuthorizer(requireAllRoles.value());
        if (!authorizer.isAuthorized((WebContext)this.webContext, this.sessionStore, profiles)) {
            throw ForbiddenAction.INSTANCE;
        }
    }
}

