/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import com.github.scribejava.apis.GoogleApi20;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.logout.GoogleLogoutActionBuilder;
import org.pac4j.core.logout.LogoutActionBuilder;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.client.OAuth20Client;
import org.pac4j.oauth.profile.google2.Google2Profile;
import org.pac4j.oauth.profile.google2.Google2ProfileDefinition;

public class Google2Client
extends OAuth20Client<Google2Profile> {
    protected static final String PROFILE_SCOPE = "profile";
    protected static final String EMAIL_SCOPE = "email";
    protected Google2Scope scope = Google2Scope.EMAIL_AND_PROFILE;

    public Google2Client() {
    }

    public Google2Client(String key, String secret) {
        this.setKey(key);
        this.setSecret(secret);
    }

    @Override
    protected void clientInit(WebContext context) {
        CommonHelper.assertNotNull((String)"scope", (Object)((Object)this.scope));
        String scopeValue = this.scope == Google2Scope.EMAIL ? EMAIL_SCOPE : (this.scope == Google2Scope.PROFILE ? PROFILE_SCOPE : PROFILE_SCOPE + " " + EMAIL_SCOPE);
        this.configuration.setApi(GoogleApi20.instance());
        this.configuration.setProfileDefinition(new Google2ProfileDefinition());
        this.configuration.setScope(scopeValue);
        this.configuration.setWithState(true);
        this.configuration.setHasBeenCancelledFactory(ctx -> {
            String error = ctx.getRequestParameter("error");
            if ("access_denied".equals(error)) {
                return true;
            }
            return false;
        });
        this.setConfiguration(this.configuration);
        this.defaultLogoutActionBuilder((LogoutActionBuilder)new GoogleLogoutActionBuilder());
        super.clientInit(context);
    }

    public Google2Scope getScope() {
        return this.scope;
    }

    public void setScope(Google2Scope scope) {
        this.scope = scope;
    }

    public static enum Google2Scope {
        EMAIL,
        PROFILE,
        EMAIL_AND_PROFILE;

    }
}

